---
title:  Monitors
author: Alisher Nurmatov
date:   29.12.2020
type:   js-api
tags:
- applet
- applet_api
- api
- js_api 
description: "[Content JS API] Monitors provides info about connected **monitors**"
---

# Monitors

Provides information about currently connected monitors. Such as manufacturer, model, serial, firmware (optional).

### Monitor object

Here is the monitor object defined as Typescript interface:

```typescript
interface IMonitor {
    manufacturer: string;
    model: string;
    serial: string;
    firmware?: string;
}
```

## All methods

::: table-responsive
| Method/Events  | Description                       | Supported since |
| ----------------- | --------------------------------- | :---------------: |
| `getList()` | Method gets list of monitors.  | 4.0.0 |
:::

### Javascript example
```javascript
// gets list of monitors
await sos.monitors.getList();
```
### Returns

```json
[
   {
      "model":"LG Ultra HD",
      "manufacturer":"GSM",
      "serial":"232111"
   }
]
```

