---
title:  Monitoring Commands
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] All commands have type prefixed with sos. string. It is not recommended using this prefix as a type in your custom commands. Predefined monitoring commands are not dispatched until monitoring is enabled. There are two ways how to enable it."
---

# Monitoring Commands

::: alert alert--warning
This is only a preview, not supported by all platforms. Supported since: 2.0.0
:::

All commands have type prefixed with sos. string. It is not recommended using this prefix as a type in your custom commands. Predefined monitoring commands are not dispatched until monitoring is enabled. There are two ways how to enable it. 

* Adding a special reserved key in Timing configuration sosMonitoring' to 1
* Sending a command to a device with type ```sos.Monitoring.EnableMonitoring``` 
OR
```sos.Monitoring.DisableMonitoring```

## List of monitoring commands:

### Typescript
```typescript
export const VideoStateChanged = 'sos.Monitoring.Video.VideoStateChanged';
export interface VideoStateChanged {
	type: typeof VideoStateChanged;
	state: 'play' | 'prepare' | 'stop' | 'pause' | 'resume' | 'ended' | 'error';
	uri: string;
	x: number;
	y: number;
	width: number;
	height: number;
}
 
 
export const TimingLoaded = 'sos.Monitoring.Timing.TimingLoaded';
export interface TimingLoaded { type: typeof TimingLoaded; }
 
export const OfflineCacheFilesListed = 'sos.Monitoring.Offline.Cache.OfflineCacheFilesListed';
export interface OfflineCacheFilesListed {
	type: typeof OfflineCacheFilesListed;
	fileUids: string[];
}
 
export const OfflineCacheFileLoaded = 'sos.Monitoring.Offline.Cache.OfflineCacheFileLoaded';
export interface OfflineCacheFileLoaded {
	type: typeof OfflineCacheFileLoaded;
	file: IFile;
}
 
export const HtmlSnapshotTaken = 'sos.Monitoring.Html.HtmlSnapshotTaken';
export interface HtmlSnapshotTaken {
	type: typeof HtmlSnapshotTaken;
	html: string;
}
 
export const ConsoleLogged = 'sos.Monitoring.Console.ConsoleLogged';
export interface ConsoleLogged {
	type: typeof ConsoleLogged;
	level: 'log' | 'debug' | 'info' | 'warn' | 'error';
	messages: string[];
}
```

To trigger some monitoring commands to be dispatched from a device. This REST API can be used to send monitoring [commands to the device](https://sdk.docs.signageos.io/api/device-monitoring-api/#Send_Device_Applet_Command_to_device). Following commands can be used:

### Typescript
```typescript
export const EnableMonitoring = 'sos.Monitoring.EnableMonitoring';
export interface EnableMonitoring { type: typeof EnableMonitoring; }
 
export const DisableMonitoring = 'sos.Monitoring.DisableMonitoring';
export interface DisableMonitoring { type: typeof DisableMonitoring; }
 
export const TakeHtmlSnapshot = 'sos.Html.TakeHtmlSnapshot';
export interface TakeHtmlSnapshot {
	type: typeof TakeHtmlSnapshot;
}
 
export const OfflineCacheListFiles = 'sos.Monitoring.Offline.Cache.OfflineCacheListFiles';
export interface OfflineCacheListFiles {
	type: typeof OfflineCacheListFiles;
}
 
export const OfflineCacheLoadFile = 'sos.Monitoring.Offline.Cache.OfflineCacheLoadFile';
export interface OfflineCacheLoadFile {
	type: typeof OfflineCacheLoadFile;
	uid: string;
}
```

## Errors
Although we are doing our best, following errors may occur when working with the commands.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 40401 | AppletCommandTypeError | Type contains invalid characters, allowed are `/^[a-zA-Z0-9\.\-_]+$/g` |
| 40402 | AppletCommandTypeError | Type is longer then 100 characters. |
| 40403 | AppletCommandTypeError | Command type must be a string. |
:::
