---
title:  Loading fonts
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] When working with custom font families, you should use this method that downloads fonts into offline storage and generates the appropriate font-face definition."
---

# Loading fonts
When working with custom font families, you should use this method that downloads fonts into offline storage and generates the appropriate font-face definition.

### All methods
::: table-responsive
| Method | Description | Supported since |
| ------ | -------- | ----- | :----------: |
| `addFont()` | Load additionally font into applet cache | 2.0.0  |
:::

### Parameters

::: table-responsive
|      Param     | Type | Required | Description                  					                                                        |
| ------- | --------- | :----------: | ------ |
| `uid`            | string | <div class="red">Yes</div> | Unique file identifier is used for later file retrieval, must contain a-z,A-Z,0-9 and . characters  |
| `append`         | HTMLElement | <div class="red">Yes</div> |Reference to HTMLElement where the generated font-face will resist                   				|
| `fontFamily`     | string | <div class="yellow">No</div> | Font family that can be referenced from your CSS                                     				|
| `formats`        | object | <div class="yellow">No</div> | URI where these formats will be downloaded from                                      				|
| `fontStretch`    | string | <div class="yellow">No</div> | Allows you to make text wider or narrower                                            				|
| `fontStyle`      | string | <div class="yellow">No</div> | Apecifies the font stlye for a text                                                 				|
|^^|^^|^^| Types: `normal`, `italic`, `oblique`, `initial`, `inherit`                                                               				|
| `fontWeight`     | string | <div class="yellow">No</div> | Sets how thick or thin characters in text should be displayed                        				|
| `unicodeRage`    | string | <div class="yellow">No</div> | Defines the range of unicode characters the font supports, default value is "U+0-10FFFF"			|
:::

### Formats parameters
|      Param     | Type | Required | Description                  					                                                        |
| ------- | --------- | :----------: | ------ |
| `woff2` | String | <div class="yellow">No</div> | URI points to woff2 file |
| `woff` | String | <div class="yellow">No</div> | URI points to woff file |
| `svg` | String | <div class="yellow">No</div> | URI points to svg file |
| `ttf` | String | <div class="yellow">No</div> | URI points to ttf file |
| `eot` | String | <div class="yellow">No</div> | URI points to eot file |

### Javascript Example
```javascript
await sos.offline.addFont({
    uid: 'my-tondo-font',
    fontFamily: 'tondo',
    fontStretch: 'normal',
    fontStyle: 'normal',
    fontWeight: 'bold',
    unicodeRange: 'U+0-10FFFF',
    formats: {
        woff2: 'https://mycms.signageos.io/fonts/tondo-woff2',
        eot: 'https://mycms.signageos.io/fonts/tondo-eot',
        ttf: 'https://mycms.signageos.io/fonts/tondo-ttf',
        svg: 'https://mycms.signageos.io/fonts/tondo-svg',
        woff: 'https://mycms.signageos.io/fonts/tondo-woff',
    },
    append: document.body,
})
.then(() => {
    console.log('Generated');
});
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fas fa-atlas svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Most properties follow the official CSS properties found</h3>
                <div class="wide-box__description">Mozilla Developer Page</div>
            </div>
            </div>
        </a>
    </div>
</div>

<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/fonts">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Example of Applet that load custom fonts</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## Usage with Typescript
You can also use all these methods with [signageOS TypeScript](https://docs.signageos.io/hc/en-us/articles/4405069154962#signageos-typescript).

```typescript
addFont(
    uid: string;
    append: HTMLElement;
    fontFamily: string;
    formats: {
        woff2: string;
        woff?: string;
        svg?: string;
        ttf?: string;
        svg?: string;
    },
    fontStretch?: string;
    fontStyle?: 'normal' | 'italic' | 'oblique' | 'initial' | 'inherit';
    fontWeight?: string;
    unicodeRange?: string;
);
```

## Errors
Although we are doing our best, following errors may occur when working with the Applet Resources.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 40105 | AppletResourcesError | Already loading file: `$$FILE_NAME$$` |
|^^|^^| Please, check your code for multiple occurrences of addFile/s methods. |
| 40106 | AppletResourcesError | Already existing file: `$$FILE_NAME$$` |
|^^|^^| Please, check your code for occurrences of addFile/s methods on lines before this error. |
| 49901 | AppletResourceError | Please, check if the used URL is correct. |
| 49902 | FileNotFoundError    | File was not found `$$FILE_ID$$` |
:::
