---
title:  Iframes
author: Josef Král
date:   7.9.2020
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
- iframe
description: "[Content JS API] We **do not recommend** to use iframes inside your Applet. However, if you have to use it, you can add full support of the sOS JS API to every one of your iframe. Just add the JS snippet script below to every page load in iframe before ending </body>. Everything will be prepared, and you can call the very same methods as described for Applet."
---

# Iframes
We **do not recommend** to use iframes inside your Applet. However, if you have to use it, you can add full support of the sOS JS API to every one of your iframe. Just add the JS snippet script below to every page load in iframe before ending </body>. Everything will be prepared, and you can call the very same methods as described for Applet.

::: alert alert--warning
The signageOS Snippet and API works **ONLY** if the iframe is served from the display's internal storage - `<iframe src="file://...`. If your iframe is served from a live URL - `<iframe src="https://your-iframe-url"...` the snippet and signageOS API will **NOT** work. This is a security limitation to prevent random site took advantage of the API and alter the display behavior. There is a simple way to [save and load your iframe from the internal storage](https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/iframes). Just make sure you are using full paths in your iframe for linking javascripts and css instead of the relative ones.

If your device can not load a file stored in local storage, such as an html, you can try to use an alternative instead of python to zip the file when you are preparing the applet.
:::

## Create applet
First applet, what will be as iframe in main applet. There is also **required event listener** to work iframes in an applet. Insert this snippet on bottom of iframe applet code.
```javascript
<script type="text/javascript">
// sOS JS API loader
!function(){window.addEventListener("message",function(t){
    if(t.source===window.parent&&"hug.api_js_uri"===t.data.type) {
        var e=t.data.uri;
        if(!e)throw new Error("Front applet JS is not set.");
        var a=document.createElement("script");
        a.setAttribute("type","text/javascript"),a.setAttribute("src",e),a.onload=a.onreadystatechange=function(){
            this.readyState&&"loaded"!=this.readyState&&"complete"!=this.readyState||(window.sos.apiJsUri=t.data.uri,window.dispatchEvent(new Event("hug.loaded")),window.dispatchEvent(new Event("sos.loaded")))},document.head.appendChild(a)}}),window.parent.postMessage({type:"hug_loader.ready"},"*")}();
</script>
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/iframes">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Applet that will be in Iframe</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## Finally, use created applet in another applet as iframe.

```javascript
window.addEventListener('sos.loaded', () => {
  sos.onReady().then(() => {
        const contentElement = document.getElementById('index');
        const iframeElement = document.getElementById('iframe');
        sos.onReady();
        
        // Download created iframe into main applet
        const iframeUri = sos.config.iframeUri || 'https://raw.githubusercontent.com/signageos/applet-examples/master/examples/iframes/iframe.html';
        const { filePath } = sos.offline.cache.loadOrSaveFile('iframe.html', iframeUri);
        
        // Setup iframe
        contentElement.innerHTML = '';
        iframeElement.src = filePath;
        iframeElement.style.display = 'block';
  });
});
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/iframes">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How to use Iframes in Applet</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>
