---
title:  Display
author: Michal Artazov
date:   12.4.2021
type:   js-api
tags:
- applet
- applet_api
- api
- display
- js_api
description: "[Content JS API] Display API allows you to query the display to find out, which features it supports."
---

# Display

Display API allows you to query the display to find out, which features it supports.
That way your applet can handle cases, when a certain feature isn't supported by a particular display.

## All methods

::: table-responsive
| Method             | Description            | Supported since |
| ------------------ | ---------------------- | :-------------: |
| `supports()` | Query, whether a certain feature is supported by the display | 3.1.0 |
:::

## supports()

Query the display to find out, whether a certain feature is supported.
To let you know, when you should call this method, we will warn you throughout the content JS API documentation
with a warning message like this one:

::: alert alert--warning
* Before using this API, ensure that the display supports serial via `sos.display.supports("SERIAL")`.
* More info [**HERE**](/api/js/content/latest/js-display#supports).
:::

::: table-responsive
| Param        | Type   | Required                   | Description     |
| ------------ | ------ | :------------------------: | --------------- |
| `capability` | string | <div class="red">Yes</div> | Capability name |
:::

### Javascript example
```javascript
const serialPort = await sos.display.supports("SERIAL");
```
