---
title:  Device Info
author: Robert Pecha
date:   13.4.2022
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] There are many device-related informations that are grouped."
---

# Device Info
There are many device-related informations that are grouped.

## All methods

::: table-responsive
| Method            | Description        | Supported since   |
| ----------------- | ------------------ | :---------------: |
| `getLocation()` | Returns location when assigned to device  | 5.2.0 |
| `getOrganizationTags()` | Returns list of organization tags when some assigned to device  | 5.2.0 |
:::

## getLocation()
Location is requested from server on application start, automatically updated when changed and persists in local storage.

### Javascript
```javascript
sos.deviceInfo.getLocation();
```

```typescript
interface IDeviceLocation {
	name: string;
	customId?: string;
	description?: string;
}

getLocation(): Promise<IDeviceLocation | null>;
```

## getOrganizationTags()
Location is requested from server on application start, automatically updated when assigned or unassigned and persists in local storage.
```javascript
sos.deviceInfo.getOrganizationTags()
```

```typescript
interface IOrganizationTag {
	name: string;
}

getOrganizationTags(): Promise<IOrganizationTag[]>;
```
