---
title:  Command
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] In some cases, you might be interested in a complete log of what the device was doing during its operation. All of your business or technical logs can be stored in our storage for later usage. You can identify which events happened or even trigger self-repairing logic."
---

# Command

In some cases, you might be interested in a complete log of what the device was doing during its operation. All of your business or technical logs can be stored in our storage for later usage. You can identify which events happened or even trigger self-repairing logic.

All commands will be available in [Applet Command REST API](https://api.docs.signageos.io/#8e7a8814-e612-1fad-0152-72f37591c7f2) and can be downloaded [historically as CSV export](https://api.docs.signageos.io/#5dceec58-ac4f-7a0c-f5ef-0854f9376e6d).

## All methods
::: table-responsive
| Methods  | Description | Supported since |
| ----------------- | ----------- | -----  |
| `dispatch()`  | Dispatch method for sending logs and data from device | 1.0.3 |
| `onCommand()`  | Event listener for incoming commands from server | 1.0.3 |

:::

## dispatch()

Dispatch() is used for sending your custom logs or data from device to signageOS.

### Parameters
::: table-responsive
|   Parameter    | Type | Required |  Description  |
| -------------- | -------------| :----------------: | ------------- |
| `type`     | String  | <div class="red">Yes</div> | Event type; can be any string **up to 100 characters**|
| custom `parameter` | String  | No | Custom parameters and values that you need to be dispatched  |
:::

### Javascript example
```javascript

/*
Example of dispatching information about file download
*/
await sos.command.dispatch({
  type: 'Files.StartLoading', // mandatory *type* with custom value
  fileName: 'my-file', // custom parameter and value
  fileType: 'txt' // custom parameter and value
});

/*
Example of dispatching applet heartbeat
*/
await sos.command.dispatch({
  type: 'Heartbeat' // mandatory *type* with custom value
});

/*
Example of dispatching applet new data
*/
const myCMSJSON = {playlist: "myPlaylist", items: [...]};

await sos.command.dispatch({
  type: 'Content.update', // mandatory *type* with custom value
  content: JSON.stringify(myCMSJSON) // custom parameter and value
});


```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/command/sending/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Sending commands</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

### Errors
::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 40401 | AppletCommandTypeError | Type contains invalid characters. |
| 40402 | AppletCommandTypeError | Type is longer then 100 characters. |
| 40403 | AppletCommandTypeError | Command type must be a string. |
:::


### Usage with Typescript
```typescript
interface ICommand {
  type: string;
}
dispatch(command: ICommand): void;
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" href="https://api.docs.signageos.io/#8e7a8814-e612-1fad-0152-72f37591c7f2">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fas fa-server svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Rest API: Get Commands</h3>
                <div class="wide-box__description">Receiving your data dispatched from devices</div>
            </div>
            </div>
        </a>
    </div>
</div>

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" href="https://api.docs.signageos.io/#5dceec58-ac4f-7a0c-f5ef-0854f9376e6d">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fas fa-server svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Rest API: Monitoring/Device Reports</h3>
                <div class="wide-box__description">Receiving historical data</div>
            </div>
            </div>
        </a>
    </div>
</div>

## onCommand()
Used for sending custom messages to online connected devices. 
This can be done through the REST API by [POST new applet command](https://api.docs.signageos.io/#511e18f3-b61b-a049-6395-8541132adc44). 
The command will be dispatched to the device & the applet can set up the logic by subscribing `onCommand` method.

**Parameters:**
::: table-responsive
|      Param     | Type   | Required | Description  |
| -------------- | ---------- | :-------: | ---------------------- |
| `command`        | object      | <div class="red">Yes</div> | Any JS object with required property type. |
| `append`         | HTMLElement  | <div class="red">Yes</div> | Type property must be string not longer then 50 characters and must contain only characters a-zA-Z0-9_- and .	|
:::

### Javascript
```javascript
sos.command.onCommand((command) => {
   // ... logic
});
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/command/receiving">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Receiving commands</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

### Usage with Typescript
```typescript
interface ICommand {
  type: string;
}
onCommand(listener: (command: ICommand) => void): void;
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" href="https://api.docs.signageos.io/#511e18f3-b61b-a049-6395-8541132adc44">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fas fa-server svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Rest API: Monitoring</h3>
                <div class="wide-box__description">Creating monitoring data</div>
            </div>
            </div>
        </a>
    </div>
</div>

## Errors
Although we are doing our best, following errors may occur when working with the commands.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 40401 | AppletCommandTypeError | Type contains invalid characters, allowed are `/^[a-zA-Z0-9\.\-_]+$/g`|
| 40402 | AppletCommandTypeError | Type is longer then 100 characters. |
| 40403 | AppletCommandTypeError | Command type must be a string. |
:::
