---
title:  Applet Basics
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] This thread contains basic methods of every Applet used to load necessary configuration or device identifications and how to create Applet."
---

# Applet Basics

This thread contains basic methods of every Applet used to load necessary configuration or device identifications and how to create Applet.

## All methods and properties

::: table-responsive
| Methods/Property  | Description | Supported since |
| ----------------- | ----------- | :---------------: |
| `onReady()`         | This method will wait until sOS object library and all dependencies are ready to be used. | 1.0.0 |
| `restore()`         | Clear all previously played videos, streams, clear display view. | 1.0.0 |
| `refresh()`         | This method will refresh the applet data and launch it again | 5.8.0 |
| `appletVersion`  | Returns current Applet version | JS API `4.5.0`, Front-display `7.8.0`|
| `config` object  | Returns object with key-values set via Timing or as a bundled config| JS API `1.5.0`, Front-display `6.8.0`|
| `config` object  | Returns object with key-values set via Timing or as a bundled config| `1.0.0`|
| `capabilities`  | Enum of device-specific capabilities and features | `1.0.0`|
:::

## Starting Applet

Your applet logic should be started **after sOS object is loaded and ready**. To start your applet you can use this example snippet.

### Javascript example:
``` javascript
/* 
CLI generated Applet 
*/
sos.onReady().then(async function () {
  startYourApplet(); // Example method to run
  // Any other code
}

/* 
Deprecated single file Applet options
*/

// option A
window.addEventListener('sos.loaded', () => {
  sos.onReady().then(() => {
    startYourApplet(); // Example method to run
    // Any other code
  });
});

// option B
async function startApplet() {
			await sos.onReady();
      // Any other code
}
window.addEventListener('sos.loaded', startApplet);
```

After sOS object is ready, there are global properties available, which can be used for Applet customization and device identification.

### Javascript syntax:
```javascript
// Authentication hash string to secure access to device resources in REST API
console.log(sos.authHash);
 
// Parsed JSON object passed to Timing for current applet & current device together
console.log(sos.config);
```

## onReady()
This method will wait until sOS object library and all dependencies are ready to be used.

::: alert alert--danger
Every Applet must contain this method, otherwise it won't work.
:::

### Javascript example:
```javascript
/* 
CLI generated Applet 
*/
sos.onReady().then(async function () {
  console.log('sos is ready', sos); // Print sOS object into console
    // Any other methods to prepare your content and applet
}

/* 
Deprecated single file Applet options
*/
window.addEventListener('sos.loaded',() => {
  sos.onReady().then(() => {
    console.log('sos is ready', sos); // Print sOS object into console
    // Any other methods to prepare your content and applet
  });
});
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/restore">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Example of Applet for basic start</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## restore()
The typical case of usage for digital signage is playing a loop with some specified duration. This method should be called always when the loop is changed. It will clear all previously played videos, streams, clear display views, and notify for garbage collection.  
It stops all video playback and clears out the memory. The following function should be triggered **only** in a case the whole playback needs to be restarted as it's completely switching the playback 'loop/playlist'.

### Javascript example:
```javascript
/* 
CLI generated Applet 
*/
sos.onReady().then(async function () {
  console.log('sos is ready', sos);
  // Any other methods to prepare, load and run content on screen
  sos.restore();
}

/* 
Deprecated single file Applet options
*/
window.addEventListener('sos.loaded', () => {
  sos.onReady().then(() => {
    console.log('sos is ready', sos);
    // Any other methods to prepare, load and run content on screen
    sos.restore();
  });
});
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/restore">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Example of Applet with restore() method</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## refresh()
AFter calling this method applet is freshly launched.

### Javascript example:
```javascript
await sos.refresh()
```

## appletVersion
This property returns current active Applet version.

### Javascript example:

```javascript
/* 
CLI generated Applet 
*/
sos.onReady().then(async function () {
  console.log('Your applet version is ' + sos.appletVersion));
}

/* 
Deprecated single file Applet options
*/
window.addEventListener('sos.loaded',() => {
  sos.onReady().then(() => console.log('Your applet version is ' + sos.appletVersion));
});
```

## Custom variables in Applet

You can pass CUSTOM key-value variables to the Applet. To do that, add your values as a Timing configuration (over Box of [Timings API](/api/rest/timing/3-timing-post-one)). Then you can access your values via `sos.config` object.

```javascript
// Parsed JSON object passed to Timing for current applet & current device together
console.log(sos.config.mySecretID);
console.log(sos.config.imgUrl);
```
<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" 
        href="https://docs.signageos.io/hc/en-us/articles/4405238989458">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fas fa-hand-point-right svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Custom variables in Applet</h3>
                <div class="wide-box__description">How to pass custom variables and cofiguration to your Applet</div>
            </div>
            </div>
        </a>
    </div>
</div>

## Applet JS API version

Each feature has “Supported since” that states for the Applet JS API version. The Applet JS API component is called Front-Applet and its version can be selected under the Applet editor.

## Capabilities

Even tough we do our best to support as many features as possible on every platform, it's not possible to use certain features on certain platforms.
That's why we also provide a capabilities API that allows you to check, if the particular device supports a feature before you try to use it.
It's recommended that you always include capability checks in your code to prevent unexpected behavior or errors in your application.

There are two kinds of capabilities - display and management.

### Display capabilities

Display capabilities refer to the capabilities of the display in terms of content, playback, peripherals, etc.

::: table-responsive
| Capability                     | Description                                                                               |
| ------------------------------ | ----------------------------------------------------------------------------------------- |
| `FILE_SYSTEM_EXTERNAL_STORAGE` | Device file system supports [external storage](/api/js/content/js-file-system) (i.e. flash drives)                          |
| `FILE_SYSTEM_FILE_CHECKSUM`    | Device is can [calculate a file checksum](/api/js/content/js-file-system#getfilechecksum) |
| `VIDEO_4K`                     | Device is capable of [playing 4K video](/api/js/content/js-video)                                                     |
| `SERIAL`                       | Device supports communication with peripherals over [serial](/api/js/content/js-hardware-serial)                                |
:::

#### Javascript example:

```javascript
if (await sos.display.supports('VIDEO_4K')) {
	// play 4K video
}
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/capabilities-content">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Example of Content Capabilities</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>


### Management capabilities

Management capabilities refer to the capabilities of the display's internal state management.

::: table-responsive
| Capability                     | Description                                                                               |
| ------------------------------ | ----------------------------------------------------------------------------------------- |
| `BATTERY_STATUS` | Device can [report its battery status](/api/js/management/1-js-management#getbatterystatus). |
| `WIFI` | Device can [connect to a Wi-Fi](/api/js/management/13-js-management-wifi#connect). |
| `WIFI_SCAN` | Device can [scan surrounding Wi-Fi devices](/api/js/management/13-js-management-wifi#scandevices). |
| `WIFI_AP` | Device is capable of [becoming a Wi-Fi endpoint](/api/js/management/13-js-management-wifi#enableap) that other devices can connect to. |
| `SET_BRIGHTNESS` | Device can change its [screen brightness](/api/js/management/5-js-management-screen#setbrightness). |
| `SET_TIME` | Device can change its [time settings](/api/js/management/6-js-management-time). |
| `NTP_TIME` | Device can [synchronize its time with an NTP server](/api/js/management/6-js-management-time#setntp). |
| `PACKAGE_INSTALL` | It's possible to [install additional packages](/api/js/management/8-js-management-package) on the device, managed by signageOS application. |
| `SET_VOLUME` | Device can change its [audio volume](/api/js/management/7-js-management-volume). |
| `SET_REMOTE_CONTROL_ENABLED` | Device can [disable control via IR remote](/api/js/management/3-js-management-remote-control) to increase security. |
:::

```javascript
if (await sos.management.supports('WIFI')) {
	// connect to wifi
}
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/capabilities-management">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Example of Management Capabilities</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>
