---
title:  Debug
author: Patrik Bily
date:   13.3.2023
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[JS API] JS API debug lets you information about remote debug mode."
---

# Debug
JS API debug lets you information about remote debug mode.

## All methods

::: table-responsive
| Method  | Description | Supported since |
| ------ | -------- | :-------------: |
| `isRemoteDebugEnabled()` | Returns information about remote debug settings | 5.8 |
| `onRemoteDebugChanged()` | Accept function which is called after remote debug settings is changed | 5.8 |
:::

## isRemoteDebugEnabled()
Method `isRemoteDebugEnabled()` returns the state of the [Device debug](https://docs.signageos.io/hc/en-us/articles/4416366711442-Device-debug) (**true** or **false**).
```javascript
await sos.debug.isRemoteDebugEnabled();
```


## onRemoteDebugChanged()
Method `onRemoteDebugChanged()` accepts a function that is executed as a callback.
```javascript
await sos.debug.onRemoteDebugChanged((enabled) => { console.log("Weinre debug is", { enabled: true })});
```
