"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var path = require("path");
var os = require("os");
var fs = require("fs-extra");
var Debug = require("debug");
var download = require("download");
var unzipper = require("unzipper");
var debug = Debug('@signageos/file:tools/download-file-win32');
var WIN32_FILE_URL = 'https://2.signageos.io/build/npm/file/file-5.03-bin-win32.zip';
var WIN32_REGEX_URL = 'https://2.signageos.io/build/npm/regex/regex-2.7-bin-win32.zip';
var WIN32_ZLIB_URL = 'https://2.signageos.io/build/npm/zlib/zlib-1.2.3-bin-win32.zip';
(function () {
    return __awaiter(this, void 0, void 0, function () {
        var tmpDir, fileZipFilename, regexFilename, zlibFilename, fileZipPath, regexZipPath, zlibZipPath, win32Path;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    tmpDir = os.tmpdir();
                    fileZipFilename = Math.random().toString().substr(2) + '.zip';
                    regexFilename = Math.random().toString().substr(2) + '.zip';
                    zlibFilename = Math.random().toString().substr(2) + '.zip';
                    fileZipPath = path.join(tmpDir, fileZipFilename);
                    regexZipPath = path.join(tmpDir, regexFilename);
                    zlibZipPath = path.join(tmpDir, zlibFilename);
                    win32Path = path.join(__dirname, '..', 'dist', 'win32');
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, , 6, 7]);
                    return [4 /*yield*/, Promise.all([
                            download(WIN32_FILE_URL, tmpDir, { filename: fileZipFilename }),
                            download(WIN32_REGEX_URL, tmpDir, { filename: regexFilename }),
                            download(WIN32_ZLIB_URL, tmpDir, { filename: zlibFilename }),
                        ])];
                case 2:
                    _a.sent();
                    if (!fs.existsSync(win32Path)) {
                        fs.mkdirSync(win32Path);
                    }
                    return [4 /*yield*/, unzipFile(fileZipPath, win32Path)];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, unzipFile(regexZipPath, win32Path)];
                case 4:
                    _a.sent();
                    return [4 /*yield*/, unzipFile(zlibZipPath, win32Path)];
                case 5:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 6:
                    try {
                        fs.unlinkSync(fileZipPath);
                    }
                    catch (error) { /* ignore */ }
                    try {
                        fs.unlinkSync(regexZipPath);
                    }
                    catch (error) { /* ignore */ }
                    try {
                        fs.unlinkSync(zlibZipPath);
                    }
                    catch (error) { /* ignore */ }
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    });
})();
function unzipFile(zipFilePath, destination) {
    return new Promise(function (resolve, reject) {
        fs.createReadStream(zipFilePath)
            .pipe(unzipper.Parse())
            .on('entry', function (entry) {
            var fileName = entry.path;
            var type = entry.type;
            debug('unzipFile', zipFilePath, fileName);
            var destFilePath = path.join(destination, fileName);
            if (type === 'File') {
                fs.ensureDirSync(path.dirname(destFilePath));
                entry.pipe(fs.createWriteStream(destFilePath));
            }
        })
            .on('finish', function () { return resolve(); })
            .on('error', function (error) { return reject(error); });
    });
}
//# sourceMappingURL=downloadFileWin32.js.map