import * as runtime from '../../../lib/runtime.js';
import type { InitOverride, ApiResponse } from '../../../lib/runtime.js';
import type { PromptsSettings, PromptsSettingsUpdate, GetCustomTextByLanguageRequest, GetPartialsRequest, PutCustomTextByLanguageRequest, PutPartialsRequest } from '../models/index.js';
declare const BaseAPI: typeof runtime.BaseAPI;
/**
 *
 */
export declare class PromptsManager extends BaseAPI {
    /**
     * Retrieve custom text for a specific prompt and language.
     * Get custom text for a prompt
     *
     * @throws {RequiredError}
     */
    getCustomTextByLanguage(requestParameters: GetCustomTextByLanguageRequest, initOverrides?: InitOverride): Promise<ApiResponse<{
        [key: string]: any;
    }>>;
    /**
     * Get template partials for a prompt - In Early Access
     * Get partials for a prompt
     *
     * @throws {RequiredError}
     */
    getPartials(requestParameters: GetPartialsRequest, initOverrides?: InitOverride): Promise<ApiResponse<{
        [key: string]: any;
    }>>;
    /**
     * Retrieve details of the Universal Login configuration of your tenant. This includes the <a href="https://auth0.com/docs/authenticate/login/auth0-universal-login/identifier-first">Identifier First Authentication</a> and <a href="https://auth0.com/docs/secure/multi-factor-authentication/fido-authentication-with-webauthn/configure-webauthn-device-biometrics-for-mfa">WebAuthn with Device Biometrics for MFA</a> features.
     * Get prompt settings
     *
     * @throws {RequiredError}
     */
    get(initOverrides?: InitOverride): Promise<ApiResponse<PromptsSettings>>;
    /**
     * Update the Universal Login configuration of your tenant. This includes the <a href="https://auth0.com/docs/authenticate/login/auth0-universal-login/identifier-first">Identifier First Authentication</a> and <a href="https://auth0.com/docs/secure/multi-factor-authentication/fido-authentication-with-webauthn/configure-webauthn-device-biometrics-for-mfa">WebAuthn with Device Biometrics for MFA</a> features.
     * Update prompt settings
     *
     * @throws {RequiredError}
     */
    update(bodyParameters: PromptsSettingsUpdate, initOverrides?: InitOverride): Promise<ApiResponse<PromptsSettings>>;
    /**
     * Set custom text for a specific prompt. Existing texts will be overwritten.
     * Set custom text for a specific prompt
     *
     * @throws {RequiredError}
     */
    updateCustomTextByLanguage(requestParameters: PutCustomTextByLanguageRequest, bodyParameters: {
        [key: string]: any;
    }, initOverrides?: InitOverride): Promise<ApiResponse<void>>;
    /**
     * Set template partials for a prompt - In Early Access
     * Set partials for a prompt
     *
     * @throws {RequiredError}
     */
    updatePartials(requestParameters: PutPartialsRequest, bodyParameters: {
        [key: string]: any;
    }, initOverrides?: InitOverride): Promise<ApiResponse<void>>;
}
export {};
