"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLock = void 0;
/**
 * It creates an outside controlled Promise<void>, which can be resolved
 * multiple times.
 */
const createLock = () => {
    let release = null;
    const promise = new Promise((resolve) => {
        release = resolve;
    });
    return {
        release,
        promise,
    };
};
exports.createLock = createLock;
//# sourceMappingURL=lock.js.map