"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStringValuesRecursive = getStringValuesRecursive;
exports.getModuleExportsRecursive = getModuleExportsRecursive;
const fs = __importStar(require("fs"));
function getStringValuesRecursive(path, ext = '.js') {
    const dirs = fs.readdirSync(path);
    let values = [];
    for (let dir of dirs) {
        const filePath = path + '/' + dir;
        const stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            values = [...values, ...getStringValuesRecursive(filePath, ext)];
        }
        else if (dir.substr(dir.lastIndexOf('.')) === ext) {
            const module = require(filePath);
            for (let name in module) {
                if (typeof module[name] === 'string') {
                    values = [...values, module[name]];
                }
            }
        }
    }
    return values;
}
function getModuleExportsRecursive(path, relativeBasePath = '.', ext = '.js') {
    const dirs = fs.readdirSync(path);
    let moduleExports = [];
    for (let dir of dirs) {
        const filePath = path + '/' + dir;
        const stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            moduleExports = [...moduleExports, ...getModuleExportsRecursive(filePath, relativeBasePath + '/' + dir, ext)];
        }
        else if (dir.substr(dir.lastIndexOf('.')) === ext) {
            const relativePath = relativeBasePath + '/' + dir.substr(0, dir.lastIndexOf('.'));
            const module = require(filePath);
            for (let name in module) {
                moduleExports = [
                    ...moduleExports,
                    {
                        relativePath,
                        export: name,
                        value: module[name],
                    },
                ];
            }
        }
    }
    return moduleExports;
}
//# sourceMappingURL=moduleDiscoverer.js.map