"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeToSeconds = timeToSeconds;
function timeToSeconds(time) {
    const timeParts = time.split(':');
    if (timeParts.length !== 3) {
        throw new Error('Invalid time format. Must be HH:mm:ss');
    }
    return timeParts.reduce((num, timePart, index) => num + parseInt(timePart) * Math.pow(60, 2 - index), 0);
}
//# sourceMappingURL=timeConverter.js.map