"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Auth0ManagementClient = void 0;
const auth0_1 = require("auth0");
const auth0_types_1 = require("../auth0.types");
const string_1 = require("../../Lib/String/string");
class Auth0ManagementClient {
    constructor({ domain, clientId, clientSecret, }) {
        this.createPasswordChangeTicket = (_a) => __awaiter(this, [_a], void 0, function* ({ email, resultUrl, connectionId }) {
            // connectionId must be matching with auth0 client
            const response = yield this.managementClient.tickets.changePassword({
                email,
                result_url: resultUrl,
                connection_id: connectionId,
            });
            return response.data.ticket;
        });
        this.getConnections = (_a) => __awaiter(this, [_a], void 0, function* ({ perPage = 50, page = 0 }) {
            return this.managementClient.connections.getAll({
                include_totals: true,
                per_page: perPage,
                page,
            });
        });
        this.getAllConnections = (_a) => __awaiter(this, [_a], void 0, function* ({ perPage = 50, page = 0 }) {
            let allConnections = [];
            let connectionsResponse = yield this.getConnections({
                perPage,
                page,
            });
            allConnections = connectionsResponse.data.connections;
            let currentPage = page;
            while (allConnections.length < connectionsResponse.data.total) {
                connectionsResponse = yield this.getConnections({
                    perPage,
                    page: currentPage,
                });
                currentPage = currentPage + perPage;
                allConnections = [...allConnections, ...connectionsResponse.data.connections];
            }
            return allConnections;
        });
        this.isSamlConnection = (_a) => __awaiter(this, [_a], void 0, function* ({ email }) {
            const emailDomain = (0, string_1.getEmailDomain)(email);
            const connections = yield this.getAllConnections({});
            const connectionByEmailDomain = connections.find((connection) => { var _a, _b; return ((_b = (_a = connection === null || connection === void 0 ? void 0 : connection.options) === null || _a === void 0 ? void 0 : _a.domain_aliases) !== null && _b !== void 0 ? _b : []).includes(emailDomain); });
            return (connectionByEmailDomain === null || connectionByEmailDomain === void 0 ? void 0 : connectionByEmailDomain.strategy) === auth0_types_1.AuthenticationStrategy.Samlp;
        });
        this.managementClient = new auth0_1.ManagementClient({
            domain,
            clientId,
            clientSecret,
        });
    }
}
exports.Auth0ManagementClient = Auth0ManagementClient;
//# sourceMappingURL=Auth0ManagementClient.js.map