import { ILegacyTimer, IShortWeekdayTimer } from './PowerTimerSettings';
import TimerType from './PowerTimerType';
import { TimerEventWeekdayNumber } from './TimerEventWeekdayNumber';
export interface ITimerEvent<T extends TimerType = TimerType> {
    weekDayNumber: TimerEventWeekdayNumber;
    type: 'ON' | 'OFF';
    time: string;
    timerType: T;
}
/**
 * @deprecated use `getLastTimerEvent` and `convertLegacyTimerToShortWeekdayTimer` instead
 */
export declare function shouldBeOnByTimers(timerSettings: {
    [type: TimerType]: ILegacyTimer;
}, now: Date): boolean | null;
/**
 * @deprecated use `getLastTimerEvent` instead
 */
export declare function shouldBeOnByTimerSettings(timerSettings: {
    [type: TimerType]: IShortWeekdayTimer;
}, now: Date): boolean | null;
export declare function orderTimerEventsByChronology<T extends TimerType>(timerEvents: ITimerEvent<T>[]): ITimerEvent<T>[];
export declare function getTimerEventsFromShortWeekday<T extends TimerType>(allSettings: Record<T, IShortWeekdayTimer & {
    type: T;
}>): ITimerEvent<T>[];
export declare function getTimerEvents<T extends TimerType>(allSettings: Record<T, ILegacyTimer & {
    type: T;
}>): ITimerEvent<`TIMER_${number}`>[];
export declare function getNextTimerEventForSameDay<T extends TimerType>(sortedTimerEvents: ITimerEvent<T>[], now: Date): ITimerEvent<T> | undefined;
export declare function getNextTimerEventForFollowingDays<T extends TimerType>(sortedTimerEvents: ITimerEvent<T>[], now: Date): ITimerEvent<T> | undefined;
export declare function getNextTimerEvent<T extends TimerType>(allSettings: Record<T, IShortWeekdayTimer & {
    type: T;
}>, now: Date, timerType: ITimerEvent['type']): ITimerEvent<T> | null;
export declare function getLastTimerEvent<T extends TimerType>(allSettings: Record<T, IShortWeekdayTimer & {
    type: T;
}>, now: Date, timerType?: ITimerEvent['type']): ITimerEvent<T> | null;
