/**
 * Repeatedly calls predicate until it returns a truthy value.
 * @returns the first truthy value returned by predicate
 */
export declare const waitUntil: <T extends unknown>(predicate: () => Promise<T>, interval?: number) => Promise<Exclude<T, false | 0 | null | undefined>>;
/**
 * Repeatedly calls resultCallback until it returns a non-null value.
 * @throws TimeoutError if resultCallback does not return a non-null value within the specified timeoutMs
 * @returns the first non-null value returned by resultCallback
 */
export declare function waitUntilNotNull<TResult>(resultCallback: () => Promise<TResult | null>, options?: {
    intervalMs?: number;
    timeoutMs?: number;
}): Promise<TResult>;
export declare class TimeoutError extends Error {
    readonly timeoutMs: number;
    constructor(timeoutMs: number);
}
/** @deprecated use named import instead */
export default waitUntil;
