"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LRUCache = exports.LRUCacheEvent = void 0;
var events_1 = require("events");
var lru_cache_1 = require("lru-cache");
var LRUCacheEvent;
(function (LRUCacheEvent) {
    LRUCacheEvent["Hit"] = "hit";
    LRUCacheEvent["Miss"] = "miss";
    LRUCacheEvent["Set"] = "set";
})(LRUCacheEvent || (exports.LRUCacheEvent = LRUCacheEvent = {}));
/**
 * LRU cache with EventEmitter implementation
 *
 * Uses node-lru-cache library under the hood ( see docs. https://github.com/isaacs/node-lru-cache#readme )
 */
var LRUCache = /** @class */ (function () {
    function LRUCache(_a) {
        var maxSize = _a.maxSize, maxAgeMs = _a.maxAgeMs, updateAgeOnGet = _a.updateAgeOnGet;
        this.emitter = new events_1.EventEmitter();
        this.cache = new lru_cache_1.LRUCache({
            max: maxSize,
            ttl: maxAgeMs,
            updateAgeOnGet: updateAgeOnGet,
        });
    }
    LRUCache.prototype.get = function (key) {
        var value = this.cache.get(key);
        this.emitter.emit(value === undefined ? LRUCacheEvent.Miss : LRUCacheEvent.Hit);
        return value;
    };
    LRUCache.prototype.set = function (key, value) {
        this.cache.set(key, value);
        this.emitter.emit(LRUCacheEvent.Set, this.cache.size);
    };
    LRUCache.prototype.on = function (event, listener) {
        this.emitter.on(event, listener);
    };
    return LRUCache;
}());
exports.LRUCache = LRUCache;
//# sourceMappingURL=lruCache.js.map