"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseProvider = void 0;
var events_1 = require("events");
var eventsHelpers_1 = require("../Events/eventsHelpers");
var generator_1 = require("../Hash/generator");
var lockedDecorator_1 = require("../Lock/lockedDecorator");
var MAX_PENDING_TASKS = 100e3;
var LOCK_NAMESPACE = 'AMQP.ResponseProvider';
var RESPONSE_QUEUE_PREFIX = '__response.';
var RESPONSE_EVENT_NAME = 'response';
var ERROR_EVENT_NAME = 'error';
var ResponseProvider = /** @class */ (function () {
    function ResponseProvider(amqplibConnection, decodeMessageBuffer) {
        this.amqplibConnection = amqplibConnection;
        this.decodeMessageBuffer = decodeMessageBuffer;
        this.eventEmitter = new events_1.EventEmitter();
        this.queueName = RESPONSE_QUEUE_PREFIX + '_' + (0, generator_1.generateUniqueHash)(8);
    }
    ResponseProvider.prototype.prepareResponse = function () {
        return __awaiter(this, void 0, void 0, function () {
            var correlationId, eventName;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ensureResponseConsumption()];
                    case 1:
                        _a.sent();
                        correlationId = (0, generator_1.generateUniqueHash)();
                        eventName = this.getResponseEventName(correlationId);
                        return [2 /*return*/, {
                                correlationId: correlationId,
                                queueName: this.queueName,
                                promise: (0, eventsHelpers_1.waitForSuccessOrFailEvents)(this.eventEmitter, eventName, ERROR_EVENT_NAME),
                            }];
                }
            });
        });
    };
    ResponseProvider.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.amqplibChannel) return [3 /*break*/, 4];
                        if (!this.consumerTag) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.amqplibChannel.cancel(this.consumerTag)];
                    case 1:
                        _a.sent();
                        this.consumerTag = undefined;
                        _a.label = 2;
                    case 2: return [4 /*yield*/, this.amqplibChannel.close()];
                    case 3:
                        _a.sent();
                        this.amqplibChannel = undefined;
                        _a.label = 4;
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    ResponseProvider.prototype.ensureResponseConsumption = function () {
        return __awaiter(this, void 0, void 0, function () {
            var amqplibChannel, consumerTag;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.consumerTag) {
                            return [2 /*return*/, this.consumerTag];
                        }
                        return [4 /*yield*/, this.getAmqplibResponseChannel(this.amqplibConnection, this.queueName)];
                    case 1:
                        amqplibChannel = _a.sent();
                        this.amqplibChannel = amqplibChannel;
                        return [4 /*yield*/, amqplibChannel.prefetch(100)];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, amqplibChannel.consume(this.queueName, function (amqplibMessage) { return __awaiter(_this, void 0, void 0, function () {
                                var message, eventName;
                                return __generator(this, function (_a) {
                                    amqplibChannel.ack(amqplibMessage);
                                    message = this.decodeMessageBuffer(amqplibMessage.content);
                                    eventName = this.getResponseEventName(amqplibMessage.properties.correlationId);
                                    this.eventEmitter.emit(eventName, message);
                                    return [2 /*return*/];
                                });
                            }); }, {
                                exclusive: true, // only one consumer should wait for response
                            })];
                    case 3:
                        consumerTag = (_a.sent()).consumerTag;
                        this.consumerTag = consumerTag;
                        return [2 /*return*/, this.consumerTag];
                }
            });
        });
    };
    ResponseProvider.prototype.getAmqplibResponseChannel = function (amqplibConnection, queueName) {
        return __awaiter(this, void 0, void 0, function () {
            var amqplibChannel;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, amqplibConnection.createChannel()];
                    case 1:
                        amqplibChannel = _a.sent();
                        return [4 /*yield*/, this.assertResponseQueue(amqplibChannel, queueName)];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, amqplibChannel];
                }
            });
        });
    };
    ResponseProvider.prototype.assertResponseQueue = function (amqplibChannel, queueName) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, amqplibChannel.assertQueue(queueName, {
                            durable: false,
                            autoDelete: false,
                            exclusive: true,
                        })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    ResponseProvider.prototype.getResponseEventName = function (correlationId) {
        return "".concat(RESPONSE_EVENT_NAME, ".").concat(correlationId);
    };
    __decorate([
        (0, lockedDecorator_1.locked)(LOCK_NAMESPACE, { maxPending: MAX_PENDING_TASKS }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], ResponseProvider.prototype, "close", null);
    __decorate([
        (0, lockedDecorator_1.locked)(LOCK_NAMESPACE, { maxPending: MAX_PENDING_TASKS }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], ResponseProvider.prototype, "ensureResponseConsumption", null);
    return ResponseProvider;
}());
exports.ResponseProvider = ResponseProvider;
//# sourceMappingURL=ResponseProvider.js.map