import IConsumeOptions from './IConsumeOptions';
import IChannel, { IBinding } from './IChannel';
import INackOptions from './INackOptions';
export type ICloseChannel = () => Promise<void>;
export default class QueueSubscriber {
    subscribe<TMessage, TResponseMessage>(createChannel: () => Promise<IChannel<TMessage>>, queueName: string, bindings: IBinding[], onMessage: (message: TMessage, headers: object) => Promise<TResponseMessage>, consumeOptions?: IConsumeOptions, onEnded?: () => void): Promise<() => Promise<ICloseChannel>>;
    subscribeRepeatable<TMessage, TResponseMessage>(createChannel: () => Promise<IChannel<TMessage>>, queueName: string, bindings: IBinding[], onMessage: (message: TMessage, headers: object) => Promise<TResponseMessage>, consumeOptions?: IConsumeOptions): Promise<() => Promise<ICloseChannel>>;
    subscribeExpectingConfirmation<TMessage, TResponseMessage>(createChannel: () => Promise<IChannel<TMessage>>, queueName: string, bindings: IBinding[], onMessage: (message: TMessage, headers: object, ack: () => void, nack: (options?: INackOptions) => void) => Promise<TResponseMessage>, consumeOptions?: IConsumeOptions, onEnded?: () => void): Promise<() => Promise<ICloseChannel>>;
    subscribeExpectingConfirmationRepeatable<TMessage, TResponseMessage>(createChannel: () => Promise<IChannel<TMessage>>, queueName: string, bindings: IBinding[], onMessage: (message: TMessage, headers: object, ack: () => void, nack: (options?: INackOptions) => void) => Promise<TResponseMessage>, consumeOptions?: IConsumeOptions): Promise<() => Promise<ICloseChannel>>;
}
