"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockedEventConsumer = void 0;
var eventQueue_1 = require("../eventQueue");
var debug_1 = __importDefault(require("debug"));
var deferredState_1 = require("./deferredState");
var withLock_1 = require("./withLock");
var debug = (0, debug_1.default)('@signageos/lib:AMQP:EventSourcing:Locked:LockedEventConsumer');
/**
 * The default values for the bind options doesn't allow concurrent processing of events.
 */
var DEFAULT_BIND_OPTIONS = {
    mainPrefetchCount: 1,
    distributedPrefetchCount: 0,
    redeliverDelayMs: 30e3,
    legacyNotification: false,
};
var mainEventQueueBindOptions = {
    queueType: 'quorum',
    singleActiveConsumer: true,
    suppressFirstError: false,
    redeliverDelayMs: 0,
    deadLetterIfErred: true,
};
var distributedEventQueueBindOptions = {
    queueType: 'classic',
    singleActiveConsumer: false,
    suppressFirstError: false,
    redeliverDelayMs: 0,
};
var DEFAULT_LOCK_KEY = '$default';
/**
 * Event consumer that consumes events in a locked manner.
 *
 * It ensures that only one event with the same lockKey is processed at a time.
 * Practically, it means that events with the same lockKey are processed sequentially.
 * However, events with different lockKeys can be processed in parallel.
 *
 * Internal implementation uses 2 separate queues (if distributedPrefetchCount > 0):
 * - Main queue for distributing events to distributed queue
 * - Distributed queue for processing events
 *
 * The main queue is "Single Active Consumer" and is locking the event processing based on lockKeys field of the event.
 * So the order of events is preserved based on the lockKeys.
 * However, the distributed queue is not locking the event processing and is processing across multiple consumers at the same time.
 * Messages in the distributed queue are transient. In case of failure, they are not lost because the main queue is persistent
 * and is not acked until the distributed queue acks the message.
 */
var LockedEventConsumer = /** @class */ (function () {
    function LockedEventConsumer(amqpConnection) {
        this.amqpConnection = amqpConnection;
        /*
        TODO this lock is not rejecting newly coming events, but only those that are currently waiting in the DeferredState.
        The right implementation should reject all events that are coming even after the first event failed.
        Otherwise, the dead-lettered events will be consumed later than the new events.
        So the order of events will be broken.
        Short-term solution would be disabling `deadLetterIfErred` option for the main queue.
        However, it would produce infinite redeliveries of the same events and rejecting them again and again.
        Other solution would be to reject all events that are coming after the first failed event
        and on top of that persist the DeferredState somewhere to be able to reject them even after the instance is restarted.
        */
        this.withLock = (0, withLock_1.createWithLock)(new deferredState_1.DeferredState());
    }
    LockedEventConsumer.prototype.bind = function (eventTypes_1, domainName_1, consumerType_1, onEvent_1) {
        return __awaiter(this, arguments, void 0, function (eventTypes, domainName, consumerType, onEvent, bindOptions) {
            var mainBindOptions, distributedBindOptions, consumeEvent, cancelConsumptions, cancelMain, distributeEvent, cancelMain, cancelDistributed;
            var _this = this;
            var _a;
            if (bindOptions === void 0) { bindOptions = DEFAULT_BIND_OPTIONS; }
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        bindOptions = __assign(__assign({}, DEFAULT_BIND_OPTIONS), bindOptions);
                        return [4 /*yield*/, (0, eventQueue_1.prepareRejected)(this.amqpConnection, domainName, consumerType, {
                                redeliverDelayMs: (_a = bindOptions.redeliverDelayMs) !== null && _a !== void 0 ? _a : DEFAULT_BIND_OPTIONS.redeliverDelayMs,
                            })];
                    case 1:
                        _b.sent();
                        mainBindOptions = this.createMainBindOptions(bindOptions);
                        distributedBindOptions = this.createDistributedBindOptions(bindOptions);
                        consumeEvent = this.createConsumeEvent(domainName, consumerType, mainBindOptions, onEvent);
                        cancelConsumptions = [];
                        if (!(bindOptions.distributedPrefetchCount === 0)) return [3 /*break*/, 3];
                        return [4 /*yield*/, (0, eventQueue_1.bindMany)(this.amqpConnection, eventTypes, domainName, consumerType, consumeEvent, mainBindOptions)];
                    case 2:
                        cancelMain = _b.sent();
                        cancelConsumptions.push(cancelMain);
                        return [3 /*break*/, 6];
                    case 3:
                        distributeEvent = this.createDistributeEvent(domainName, consumerType, distributedBindOptions);
                        return [4 /*yield*/, (0, eventQueue_1.bindMany)(this.amqpConnection, eventTypes, domainName, consumerType, distributeEvent, mainBindOptions)];
                    case 4:
                        cancelMain = _b.sent();
                        return [4 /*yield*/, (0, eventQueue_1.bindRPC)(this.amqpConnection, domainName, consumerType, consumeEvent, distributedBindOptions)];
                    case 5:
                        cancelDistributed = _b.sent();
                        cancelConsumptions.push(cancelMain);
                        cancelConsumptions.push(cancelDistributed);
                        _b.label = 6;
                    case 6: return [2 /*return*/, function () { return __awaiter(_this, void 0, void 0, function () {
                            var closeChannels;
                            var _this = this;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, Promise.all(cancelConsumptions.map(function (cancel) { return cancel(); }))];
                                    case 1:
                                        closeChannels = _a.sent();
                                        return [2 /*return*/, function () { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    switch (_a.label) {
                                                        case 0: return [4 /*yield*/, Promise.all(closeChannels.map(function (close) { return close(); }))];
                                                        case 1:
                                                            _a.sent();
                                                            return [2 /*return*/];
                                                    }
                                                });
                                            }); }];
                                }
                            });
                        }); }];
                }
            });
        });
    };
    LockedEventConsumer.prototype.createMainBindOptions = function (bindOptions) {
        var _a;
        return __assign(__assign({}, mainEventQueueBindOptions), { prefetchCount: bindOptions.mainPrefetchCount, notification: (_a = bindOptions.legacyNotification) !== null && _a !== void 0 ? _a : false });
    };
    LockedEventConsumer.prototype.createConsumeEvent = function (domainName, consumerType, bindOptions, onEvent) {
        var _this = this;
        return function (event) { return __awaiter(_this, void 0, void 0, function () {
            var logMetadata;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        logMetadata = {
                            domainName: domainName,
                            consumerType: consumerType,
                            bindOptions: bindOptions,
                            event: event,
                        };
                        debug("Consuming event ".concat(event.type, " from ").concat(domainName, ".").concat(consumerType), logMetadata);
                        return [4 /*yield*/, onEvent(event)];
                    case 1:
                        _a.sent();
                        debug("Consumed event ".concat(event.type, " from ").concat(domainName, ".").concat(consumerType), logMetadata);
                        return [2 /*return*/];
                }
            });
        }); };
    };
    LockedEventConsumer.prototype.createDistributedBindOptions = function (bindOptions) {
        return __assign(__assign({}, distributedEventQueueBindOptions), { prefetchCount: bindOptions.distributedPrefetchCount });
    };
    LockedEventConsumer.prototype.createDistributeEvent = function (domainName, consumerType, bindOptions) {
        var _this = this;
        return function (event) { return __awaiter(_this, void 0, void 0, function () {
            var logMetadata, lockKeys;
            var _this = this;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        logMetadata = {
                            domainName: domainName,
                            consumerType: consumerType,
                            bindOptions: bindOptions,
                            event: event,
                        };
                        debug("Received event ".concat(event.type, " to ").concat(domainName, ".").concat(consumerType), logMetadata);
                        lockKeys = (_a = event.lockKeys) !== null && _a !== void 0 ? _a : [DEFAULT_LOCK_KEY];
                        return [4 /*yield*/, this.withLock(lockKeys, function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            debug("Distributing event ".concat(event.type, " to ").concat(domainName, ".").concat(consumerType), logMetadata);
                                            // TODO Add timeout for processing event, because it can be stucked until the instance is restarted
                                            return [4 /*yield*/, (0, eventQueue_1.processRPC)(this.amqpConnection, domainName, consumerType, event, { persistent: false })];
                                        case 1:
                                            // TODO Add timeout for processing event, because it can be stucked until the instance is restarted
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); })];
                    case 1:
                        _b.sent();
                        debug("Distributed event consumed ".concat(event.type, " to ").concat(domainName, ".").concat(consumerType), logMetadata);
                        return [2 /*return*/];
                }
            });
        }); };
    };
    return LockedEventConsumer;
}());
exports.LockedEventConsumer = LockedEventConsumer;
//# sourceMappingURL=lockedEventConsumer.js.map