# General Library

This repository contains all sets of generic TypeScript tools and utils for different technologies, like databases: 'MongoDB, AMQP
(RabbitMQ), Redis, PostgreSQL, InfluxDB', monitoring in Prometheus, wrappers and helpers for Azure SDK, Browser Storage, time management,
observables, async iterators and a lot more.

It's published as an npm library @signageos/lib that can be used in any project that requires and is using those technologies to simplify
the business logic.

Contents of this library should eventually be migrated into more granular packages in this repo.

> :information_source: If you are not logged in, run
> `docker login https://registry.gitlab.com/ -u YOUR_USERNAME@signageos.io -p YOUR_PERSONAL_ACCESS_TOKEN`

1. `docker-compose up -d`
2.

```
cat >> config/env.test.json << EOF
{
  "amqp_dsn": "amqp://guest:guest@localhost:5672/",
  "redis_dsn": "redis://localhost:6379",
  "mongo_db_dsn": "mongodb://localhost:27017/test",
  "postgres_dsn": "postgres://postgres:postgres@localhost:5432/test"
}
EOF
```

3. `npm test`

# Limitations
This repository shouldn't have any `@signageos` dependencies. Otherwise there will be problem with cyclic dependencies

<!-- TODO: Remove when replaced with secret manager -->
## Tests

Some integration tests require secrets which are specified in the `.env.test.yaml`. These values can be exported to
the `.env.docker-compose` with running script `bash tools/get-test-env-variables.sh`.

## CI/CD

Required secrets from test needs to be added to the gitlab CI/CD variables

## Tools

`get-test-env-variables.sh` - exports environment variables from helm to `.env.docker-compose`. Must be run with `bash`
