"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionTypeSchema = exports.SubscriptionType = void 0;
const zod_1 = require("zod");
var SubscriptionType;
(function (SubscriptionType) {
    SubscriptionType["Open"] = "open";
    SubscriptionType["Basic"] = "basic";
    SubscriptionType["Medium"] = "medium";
    SubscriptionType["All"] = "all";
    // Obsolete values below - kept because of the backward compatibility
    /** @deprecated */
    SubscriptionType["Platform"] = "platform";
})(SubscriptionType || (exports.SubscriptionType = SubscriptionType = {}));
exports.SubscriptionTypeSchema = zod_1.z.nativeEnum(SubscriptionType);
