"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AndroidInstalledSpecsSchema = exports.AndroidInstallationFromUriSpecsSchema = exports.AndroidPackageSpecsSchema = exports.AndroidIdentificationSpecsSchema = exports.Abis = void 0;
const zod_1 = require("zod");
/**
 * List of all possible supported ABIs.
 */
exports.Abis = ['x86', 'x86_64', 'armeabi-v7a', 'arm64-v8a'];
/** It can be alternatively any string because it's dynamic value and depends on device */
const AbiSchema = zod_1.z.enum(exports.Abis).or(zod_1.z.string());
exports.AndroidIdentificationSpecsSchema = zod_1.z.object({
    /**
     * Internal package name of android application.
     * Java notation, e.g.: io.signageos.android
     */
    packageName: zod_1.z.string(),
});
exports.AndroidPackageSpecsSchema = zod_1.z.object({
    /**
     * Application ID as specified in the APK manifest, i.e. `com.example.app`.
     * See [definition](https://developer.android.com/guide/topics/manifest/manifest-element#package).
     */
    packageName: zod_1.z.string(),
    /**
     * Min SDK version as specified in the APK manifest.
     * See [definition](https://developer.android.com/guide/topics/manifest/uses-sdk-element#target).
     */
    sdkVersion: zod_1.z.number(),
    /**
     * List of supported ABIs.
     * If the package doesn't contain any native code (and can run on any CPU) this will be `undefined`.
     * Read more about [Android ABIs](https://developer.android.com/ndk/guides/abis).
     */
    supportedAbis: zod_1.z.array(AbiSchema).optional(),
    /**
     * - `true`: This APK may be loaded as a library by other apps.
     *   In practice, it needs to provide 32-bit native code
     *   on 64-bit devices capable of running in 32-bit mode.
     *   Can ony be installed on devices that support *all* of {@link supportedAbis}.
     *   An example of such app is the WebView.
     * - `false` (default): This is a standalone APK.
     *   Can be installed on devices that support *any* of {@link supportedAbis}.
     */
    multiArch: zod_1.z.boolean().nullable().optional(),
    /**
     * Version code as specifed in the APK manifest.
     * See [definition](https://developer.android.com/guide/topics/manifest/manifest-element#vcode).
     */
    versionCode: zod_1.z.number().optional(),
    /**
     * Target SDK version as specified in the APK manifest.
     * See [definition](https://developer.android.com/guide/topics/manifest/uses-sdk-element#target).
     */
    targetSdkVersion: zod_1.z.number().optional(),
});
exports.AndroidInstallationFromUriSpecsSchema = zod_1.z.object({
    /** `packageName` as defined by the APK manifest, i.e. com.example.app */
    packageName: zod_1.z.string(),
    /** SHA-256 hash of the APK file. */
    apkSha256: zod_1.z.string().optional(),
    /**
     * SHA-256 hash of the APK signature.
     * Older Core Apps did not have this field, so it can be omitted.
     */
    signatureSha256: zod_1.z.string().optional(),
});
/**
 * The specifications of installed android package (APK file).
 * It contains extra information specific only for the android platform (applicationType).
 * Some of those can be used as a source for buildHash computation.
 */
exports.AndroidInstalledSpecsSchema = zod_1.z.object({
    /** `packageName` as defined by the APK manifest, i.e. com.example.app */
    packageName: zod_1.z.string(),
    /** `versionCode` as defined by the APK manifest, i.e. 200050 */
    versionCode: zod_1.z.number(),
    /** SHA-256 hash of the APK file. */
    apkSha256: zod_1.z.string(),
    /**
     * `versionName` as defined by the APK manifest, i.e. 2.3.0.
     * Older Core Apps did not have this field, so it can be omitted.
     */
    versionName: zod_1.z.string().optional(),
    /**
     * SHA-256 hash of the APK signature.
     * Older Core Apps did not have this field, so it can be omitted.
     */
    signatureSha256: zod_1.z.string().optional(),
});
