"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidWeekday = exports.InvalidWeekdays = void 0;
exports.default = validateWeekdays;
const Validation_1 = require("../../../Validation/Validation");
const isValidWeekday_1 = require("./isValidWeekday");
function validateWeekdays(weekdays) {
    const validation = (0, Validation_1.createValidation)(weekdays);
    if (!Array.isArray(weekdays)) {
        validation.addError(new InvalidWeekdays(weekdays));
    }
    else {
        weekdays.forEach((weekday) => {
            const notValidWeekday = !(0, isValidWeekday_1.default)(weekday);
            if (notValidWeekday) {
                validation.addError(new InvalidWeekday(weekday));
            }
        });
    }
    return validation.getOutput();
}
class InvalidWeekdays extends Error {
    constructor(weekdays) {
        super(`Weekdays array is invalid: ${weekdays}`);
    }
}
exports.InvalidWeekdays = InvalidWeekdays;
class InvalidWeekday extends Error {
    constructor(weekday) {
        super(`Weekday in weekdays is not valid: ${weekday}`);
    }
}
exports.InvalidWeekday = InvalidWeekday;
