"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validProprietaryKeys = exports.validNativeKeys = void 0;
exports.validateNativeTimer = validateNativeTimer;
exports.validateProprietaryTimer = validateProprietaryTimer;
exports.validateCommonTimer = validateCommonTimer;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
const isValidTime_1 = require("../../Time/Validation/isValidTime");
const validateShortWeekdays_1 = require("../../Time/Validation/validateShortWeekdays");
const isValidNativeTimerType_1 = require("../../Timer/Validation/isValidNativeTimerType");
const isValidProprietaryTimerType_1 = require("../../Timer/Validation/isValidProprietaryTimerType");
const validateKeepAppletRunning_1 = require("./validateKeepAppletRunning");
const validateTimerSettings_1 = require("./validateTimerSettings");
const validateVolumeSettings_1 = require("./validateVolumeSettings");
exports.validNativeKeys = {
    timeOff: true,
    timeOn: true,
    type: true,
    weekdays: true,
    volume: true,
};
exports.validProprietaryKeys = {
    timeOff: true,
    timeOn: true,
    type: true,
    weekdays: true,
    ['volume']: true, // volume is not valid proprietary key, but it should remain allowed for BC
    keepAppletRunning: true,
};
function validateNativeTimer(settings) {
    var _a;
    const validation = validateCommonTimer(settings);
    const { type, volume } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notTypeValid = !(0, isValidNativeTimerType_1.isValidNativeTimerType)(type);
    if (notTypeValid) {
        validation.addError(new validateTimerSettings_1.InvalidTimerType(type));
    }
    const notVolumeValid = !(0, validateVolumeSettings_1.isValidVolumeValue)(volume);
    if (notVolumeValid) {
        validation.addError(new validateTimerSettings_1.InvalidTimerVolume(volume));
    }
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validNativeKeys);
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function validateProprietaryTimer(settings) {
    var _a;
    const validation = validateCommonTimer(settings);
    const { type, keepAppletRunning } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notTypeValid = !(0, isValidProprietaryTimerType_1.isValidProprietaryTimerType)(type);
    if (notTypeValid) {
        validation.addError(new validateTimerSettings_1.InvalidTimerType(type));
    }
    const notKeepAppletRunning = !(0, validateKeepAppletRunning_1.isValidKeepAppletRunningValue)(keepAppletRunning);
    if (notKeepAppletRunning) {
        validation.addError(new validateKeepAppletRunning_1.InvalidKeepAppletRunning(keepAppletRunning));
    }
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validProprietaryKeys);
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function validateCommonTimer(settings) {
    var _a;
    const { timeOn, timeOff, weekdays } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notTimeOnValid = !(timeOn === undefined || (0, isValidTime_1.default)(timeOn));
    const notTimeOffValid = !(timeOff === undefined || (0, isValidTime_1.default)(timeOff));
    const weekdaysValidation = (0, validateShortWeekdays_1.default)(weekdays);
    const validation = (0, Validation_1.createValidation)(settings);
    if (notTimeOnValid) {
        validation.addError(new validateTimerSettings_1.InvalidTimerTimeOn(timeOn));
    }
    if (notTimeOffValid) {
        validation.addError(new validateTimerSettings_1.InvalidTimerTimeOff(timeOff));
    }
    validation.addError(...weekdaysValidation.getErrors());
    return validation;
}
