"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidTimerVolume = exports.InvalidTimerTimeOff = exports.InvalidTimerTimeOn = exports.InvalidTimerType = exports.validProprietaryKeys = exports.validNativeKeys = void 0;
exports.default = validateTimerSettings;
exports.validateProprietaryTimerSettings = validateProprietaryTimerSettings;
exports.validateCommonTimerSettings = validateCommonTimerSettings;
const isValidTime_1 = require("../../Time/Validation/isValidTime");
const validateVolumeSettings_1 = require("./validateVolumeSettings");
const validateWeekdays_1 = require("../../Time/Validation/validateWeekdays");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
const validateKeepAppletRunning_1 = require("./validateKeepAppletRunning");
const isValidNativeTimerType_1 = require("../../Timer/Validation/isValidNativeTimerType");
const isValidProprietaryTimerType_1 = require("../../Timer/Validation/isValidProprietaryTimerType");
exports.validNativeKeys = {
    timeOff: true,
    timeOn: true,
    type: true,
    volume: true,
    weekdays: true,
};
exports.validProprietaryKeys = {
    timeOff: true,
    timeOn: true,
    type: true,
    weekdays: true,
    keepAppletRunning: true,
};
function validateTimerSettings(settings) {
    var _a, _b;
    const validation = validateCommonTimerSettings(settings);
    const { type } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notTypeValid = !(0, isValidNativeTimerType_1.isValidNativeTimerType)(type);
    if (notTypeValid) {
        validation.addError(new InvalidTimerType(type));
    }
    const { volume } = (_b = settings) !== null && _b !== void 0 ? _b : {};
    const notVolumeValid = !(0, validateVolumeSettings_1.isValidVolumeValue)(volume);
    if (notVolumeValid) {
        validation.addError(new InvalidTimerVolume(volume));
    }
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validNativeKeys);
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function validateProprietaryTimerSettings(settings) {
    var _a;
    const validation = validateCommonTimerSettings(settings);
    const { type, keepAppletRunning } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notTypeValid = !(0, isValidProprietaryTimerType_1.isValidProprietaryTimerType)(type);
    if (notTypeValid) {
        validation.addError(new InvalidTimerType(type));
    }
    const notKeepAppletRunningValid = !(0, validateKeepAppletRunning_1.isValidKeepAppletRunningValue)(keepAppletRunning);
    if (notKeepAppletRunningValid) {
        validation.addError(new validateKeepAppletRunning_1.InvalidKeepAppletRunning(keepAppletRunning));
    }
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validProprietaryKeys);
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function validateCommonTimerSettings(settings) {
    var _a;
    const { timeOn, timeOff, weekdays } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notTimeOnValid = !(timeOn === undefined || (0, isValidTime_1.default)(timeOn));
    const notTimeOffValid = !(timeOff === undefined || (0, isValidTime_1.default)(timeOff));
    const weekdaysValidation = (0, validateWeekdays_1.default)(weekdays);
    const validation = (0, Validation_1.createValidation)(settings);
    if (notTimeOnValid) {
        validation.addError(new InvalidTimerTimeOn(timeOn));
    }
    if (notTimeOffValid) {
        validation.addError(new InvalidTimerTimeOff(timeOff));
    }
    validation.addError(...weekdaysValidation.getErrors());
    return validation;
}
class InvalidTimerType extends Error {
    constructor(type) {
        super(`Timer Type is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidTimerType = InvalidTimerType;
class InvalidTimerTimeOn extends Error {
    constructor(timeOn) {
        super(`Timer Time On is not valid: ${JSON.stringify(timeOn)}`);
    }
}
exports.InvalidTimerTimeOn = InvalidTimerTimeOn;
class InvalidTimerTimeOff extends Error {
    constructor(timeOff) {
        super(`Timer Time Off is not valid: ${JSON.stringify(timeOff)}`);
    }
}
exports.InvalidTimerTimeOff = InvalidTimerTimeOff;
class InvalidTimerVolume extends Error {
    constructor(volume) {
        super(`Timer Volume is not in range 0 to 100: ${JSON.stringify(volume)}`);
    }
}
exports.InvalidTimerVolume = InvalidTimerVolume;
