"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevicePackageUninstallationSchema = exports.AndroidDevicePackageUninstallationSchema = void 0;
const zod_1 = require("zod");
const ApplicationType_1 = require("../../Application/ApplicationType");
const specs_1 = require("../../Package/Android/specs");
const BaseDevicePackageUninstallationSchema = zod_1.z.strictObject({
    applicationType: ApplicationType_1.ApplicationTypeSchema,
    /**
     * Proprietary package name (platform independent)
     */
    packageName: zod_1.z.string(),
    /**
     * Platform specific information differs for each application type
     */
    specs: zod_1.z.object({}),
});
exports.AndroidDevicePackageUninstallationSchema = BaseDevicePackageUninstallationSchema.extend({
    applicationType: zod_1.z.literal('android'),
    specs: specs_1.AndroidIdentificationSpecsSchema,
});
exports.DevicePackageUninstallationSchema = exports.AndroidDevicePackageUninstallationSchema;
