"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidAlertType = void 0;
exports.default = isAlertTypeValid;
const AlertType_1 = require("../AlertType");
const Validation_1 = require("../../Validation/Validation");
function isAlertTypeValid(alertType) {
    const validation = (0, Validation_1.createValidation)(alertType);
    const notValidAlertType = !(typeof alertType === 'string' && alertType in AlertType_1.AlertType);
    if (notValidAlertType) {
        validation.addError(new InvalidAlertType(alertType));
    }
    return validation.getOutput();
}
class InvalidAlertType extends Error {
    constructor(type) {
        super(`AlertType is not valid type: ${type}`);
    }
}
exports.InvalidAlertType = InvalidAlertType;
