import * as redis from 'redis';
import IRedisPool from './IRedisPool';
import { IOptions as IPoolOptions } from '../GenericPool/options';
import { IThirdPartyConnection } from '../ThirdParty/connection';
export interface IRedisConnection extends IThirdPartyConnection {
    connection: redis.RedisClient;
    pool: IRedisPool;
    /**
     * You can get a sub-connection to the specific database using a number of database.
     * By default is usually used one specific num=0 for all logic.
     * But there can be switched for single usage to different sub-database.
     * The original connection is untouched and new one is connected.
     */
    getDB: (num: number) => IRedisConnection;
}
export interface Options extends IPoolOptions {
    infiniteReconnecting?: boolean;
}
export declare function createRedisConnection(redisDsn: string, options?: Options, onExit?: () => void): IRedisConnection;
