"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeferred = createDeferred;
function createDeferred(throwIfResolvedMultipleTimes) {
    let resolved = false;
    let [promiseResolve, promiseReject] = [undefined, undefined];
    const promise = new Promise((resolve, reject) => {
        [promiseResolve, promiseReject] = [resolve, reject];
    });
    const handleIfIncorrect = () => {
        if (resolved) {
            if (throwIfResolvedMultipleTimes) {
                throw new Error("Deferred shouldn't be resolved more than once.");
            }
            else if (throwIfResolvedMultipleTimes === undefined) {
                // Print only warning for BC
                console.warn(new Error("Deferred shouldn't be resolved more than once, ignoring this call."));
            }
        }
        resolved = true;
    };
    return {
        promise,
        resolve: (value) => {
            handleIfIncorrect();
            promiseResolve(value);
        },
        reject: (e) => {
            handleIfIncorrect();
            promiseReject(e);
        },
    };
}
//# sourceMappingURL=deferred.js.map