"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryConnection = tryConnection;
exports.getDsn = getDsn;
exports.withoutOptions = withoutOptions;
exports.doConnectionCallback = doConnectionCallback;
const _ = __importStar(require("lodash"));
const mongodb = __importStar(require("mongodb"));
const connection_string_parser_1 = require("connection-string-parser");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/lib:MongoDB:proprietaryCluster');
const connectionStringParser = new connection_string_parser_1.ConnectionStringParser({
    scheme: 'mongodb',
    hosts: [],
});
function tryConnection(host, parameters) {
    return __awaiter(this, void 0, void 0, function* () {
        return doConnectionCallback(host, parameters, (connection) => __awaiter(this, void 0, void 0, function* () {
            return yield connection.db(parameters.endpoint).stats();
        }));
    });
}
function getDsn(host, parameters, omitParamNames = []) {
    return connectionStringParser.format(withoutOptions(Object.assign(Object.assign({}, parameters), { hosts: [host] }), omitParamNames));
}
function withoutOptions(parameters, omitParamNames = []) {
    return Object.assign(Object.assign({}, parameters), { options: _.omit(parameters.options, 'proprietaryServerSelectionStrategy', 'proprietaryReplicaSet', ...omitParamNames) });
}
function doConnectionCallback(host, parameters, callback) {
    return __awaiter(this, void 0, void 0, function* () {
        const dsn = getDsn(host, parameters);
        const connection = yield mongodb.MongoClient.connect(dsn, {
            connectTimeoutMS: 5e3, // keep short timeout for connection because slow connections has latency bad as well
            socketTimeoutMS: 5e3,
            serverSelectionTimeoutMS: 5e3, // in proprietary replica set, host should have 1 node, so this is not usually used
        });
        const result = yield callback(connection);
        debug('connection callback result', host, parameters, result);
        yield connection.close();
        return result;
    });
}
//# sourceMappingURL=helper.js.map