"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WinstonLogger = void 0;
class WinstonLogger {
    constructor(logger, namespace) {
        this.logger = logger;
        this.namespace = namespace;
        this.settings = {
            ignoredLogNamespaces: [],
        };
        this.settings = {
            ignoredLogNamespaces: typeof process.env.IGNORED_LOG_NAMESPACES !== 'undefined' ? process.env.IGNORED_LOG_NAMESPACES.split(',') : [],
        };
    }
    error(message, meta) {
        this.log('error', message, meta);
        return this;
    }
    warn(message, meta) {
        this.log('warn', message, meta);
        return this;
    }
    info(message, meta) {
        this.log('info', message, meta);
        return this;
    }
    debug(message, meta) {
        this.log('debug', message, meta);
        return this;
    }
    createNamespace(namespace) {
        const prefix = this.namespace ? `${this.namespace}:` : '';
        return new WinstonLogger(this.logger, prefix + namespace);
    }
    setIgnoredLogNamespaces(ignoredLogNamespaces) {
        this.settings.ignoredLogNamespaces = ignoredLogNamespaces;
    }
    /**
     * Log a message with the given level
     *
     * Logging can be disabled for specific namespaces by setting the `IGNORED_LOG_NAMESPACES` environment variable.
     */
    log(level, message, meta) {
        const ignoreLogs = typeof this.namespace !== 'undefined' && this.settings.ignoredLogNamespaces.includes(this.namespace);
        if (!ignoreLogs) {
            this.logger.log(level, message, Object.assign({ namespace: this.namespace }, meta));
        }
    }
}
exports.WinstonLogger = WinstonLogger;
//# sourceMappingURL=logger.js.map