"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsS3 = void 0;
const fs_1 = require("fs");
const client_s3_1 = require("@aws-sdk/client-s3");
const fs_extra_1 = require("fs-extra");
const debugDecorator_1 = require("../Debug/debugDecorator");
const config_1 = require("./config");
const lib_storage_1 = require("@aws-sdk/lib-storage");
const s3_request_presigner_1 = require("@aws-sdk/s3-request-presigner");
const DEBUG_NAMESPACE = '@signageos/lib:AWS:S3';
/**
 * Wrapper for AWS S3 client
 *
 * All commonly used operations with S3 will be implemented here to provide a consistent interface across the codebase.
 */
class AwsS3 {
    /**
     * @param config.forcePathStyle - Whether to use path style URLs for S3 requests.
     * Defaults to the value of the `AWS_S3_FORCE_PATH_STYLE_URLS` environment variable or false if not set.
     */
    constructor(config = {}) {
        config = (0, config_1.getUpdatedS3ClientConfigWithCustomEnvVars)(config);
        this.client = new client_s3_1.S3Client(config);
    }
    uploadFile(_a) {
        return __awaiter(this, arguments, void 0, function* ({ filePath, bucket, remotePath, contentType, metadata }) {
            const fileStream = (0, fs_1.createReadStream)(filePath);
            const upload = new lib_storage_1.Upload({
                client: this.client,
                params: { Bucket: bucket, Key: remotePath, Body: fileStream, ContentType: contentType, Metadata: metadata },
            });
            yield upload.done();
        });
    }
    uploadContent(_a) {
        return __awaiter(this, arguments, void 0, function* ({ content, bucket, remotePath, contentType, metadata }) {
            const upload = new lib_storage_1.Upload({
                client: this.client,
                params: { Bucket: bucket, Key: remotePath, Body: content, ContentType: contentType, Metadata: metadata },
            });
            yield upload.done();
        });
    }
    uploadStream(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, remotePath, stream }) {
            const upload = new lib_storage_1.Upload({
                client: this.client,
                params: {
                    Bucket: bucket,
                    Key: remotePath,
                    Body: stream,
                },
            });
            yield upload.done();
        });
    }
    downloadFile(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, remotePath, filePath }) {
            const command = new client_s3_1.GetObjectCommand({
                Bucket: bucket,
                Key: remotePath,
            });
            const { Body: body } = yield this.client.send(command);
            if (body === undefined) {
                throw new Error('Body is undefined');
            }
            const response = body;
            const nodejsWriteStream = (0, fs_extra_1.createWriteStream)(filePath);
            response.pipe(nodejsWriteStream);
            yield new Promise((resolve, reject) => {
                nodejsWriteStream.on('finish', resolve);
                nodejsWriteStream.on('error', reject);
            });
        });
    }
    listFiles(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, remotePath, maxKeys, startAfterKey }) {
            const command = new client_s3_1.ListObjectsV2Command({
                Bucket: bucket,
                Prefix: remotePath.endsWith('/') ? remotePath : remotePath + '/',
                MaxKeys: maxKeys,
                StartAfter: startAfterKey,
            });
            const { Contents: contents } = yield this.client.send(command);
            if (contents === undefined) {
                return [];
            }
            return contents.map((content) => content.Key).filter((key) => key !== undefined);
        });
    }
    deleteFile(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, remotePath }) {
            const command = new client_s3_1.DeleteObjectCommand({
                Bucket: bucket,
                Key: remotePath,
            });
            yield this.client.send(command);
        });
    }
    getObjectHead(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, remotePath }) {
            const command = new client_s3_1.HeadObjectCommand({
                Bucket: bucket,
                Key: remotePath,
            });
            return yield this.client.send(command);
        });
    }
    getObject(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, key }) {
            const command = new client_s3_1.GetObjectCommand({
                Bucket: bucket,
                Key: key,
            });
            const response = yield this.client.send(command);
            return {
                Body: response.Body,
                ContentType: response.ContentType,
            };
        });
    }
    deleteObject(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, key }) {
            const command = new client_s3_1.DeleteObjectCommand({
                Bucket: bucket,
                Key: key,
            });
            yield this.client.send(command);
        });
    }
    createBucket(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket }) {
            const command = new client_s3_1.CreateBucketCommand({
                Bucket: bucket,
            });
            return yield this.client.send(command);
        });
    }
    deleteBucket(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket }) {
            const command = new client_s3_1.DeleteBucketCommand({
                Bucket: bucket,
            });
            yield this.client.send(command);
        });
    }
    bucketExists(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket }) {
            const command = new client_s3_1.HeadBucketCommand({
                Bucket: bucket,
            });
            try {
                yield this.client.send(command);
                return true;
            }
            catch (e) {
                return false;
            }
        });
    }
    putBucketPolicy(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, policy }) {
            const command = new client_s3_1.PutBucketPolicyCommand({
                Bucket: bucket,
                Policy: policy,
            });
            yield this.client.send(command);
        });
    }
    getPresignedUrl(_a) {
        return __awaiter(this, arguments, void 0, function* ({ bucket, remotePath, expirationInSec }) {
            const command = new client_s3_1.GetObjectCommand({
                Bucket: bucket,
                Key: remotePath,
            });
            return yield (0, s3_request_presigner_1.getSignedUrl)(this.client, command, { expiresIn: expirationInSec });
        });
    }
}
exports.AwsS3 = AwsS3;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "uploadFile", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "uploadContent", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "uploadStream", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "downloadFile", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "listFiles", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "deleteFile", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "getObjectHead", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "getObject", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "deleteObject", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "createBucket", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "deleteBucket", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "bucketExists", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "putBucketPolicy", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "getPresignedUrl", null);
//# sourceMappingURL=S3.js.map