"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertRejectableQueue = assertRejectableQueue;
const ChannelProvider_1 = require("./ChannelProvider");
function assertRejectableQueue(channel_1, queueName_1, maxPriority_1) {
    return __awaiter(this, arguments, void 0, function* (channel, queueName, maxPriority, durable = true, singleActiveConsumer = false, deadLetterExchange = '', deadLetterRoutingKey = ChannelProvider_1.REJECTED_QUEUE_PREFIX + queueName, queueType = 'classic') {
        const args = {};
        if (singleActiveConsumer) {
            args['x-single-active-consumer'] = singleActiveConsumer;
        }
        if (queueType === 'quorum') {
            // default is classic
            args['x-queue-type'] = 'quorum';
            args['x-quorum-initial-group-size'] = ChannelProvider_1.DEFAULT_QUORUM_INITIAL_GROUP_SIZE;
        }
        yield channel.assertQueue(queueName, {
            deadLetterExchange,
            deadLetterRoutingKey,
            maxPriority,
            durable,
            arguments: args,
        });
    });
}
//# sourceMappingURL=queueConfigurator.js.map