import ILegacyTimer from './Power/PowerTimerSettings';
import TimerWeekday from './Power/PowerTimerWeekday';
import LongWeekdayEnum, { ShortWeekdayEnum } from './Power/PowerTimerWeekdayEnum';
export declare const convertWeekday: {
    fromShort(weekdays: `${ShortWeekdayEnum}`[]): {
        toLegacy(): Omit<ILegacyTimer, "type" | "timeOn" | "timeOff">;
        toLong(): LongWeekdayEnum[];
        toTimerWeekday(): TimerWeekday[];
    };
    fromLong(weekdays: `${LongWeekdayEnum}`[]): {
        toShort(): ShortWeekdayEnum[];
        toLegacy(): Omit<ILegacyTimer, "type" | "timeOn" | "timeOff">;
        toTimerWeekday(): TimerWeekday[];
    };
    fromLegacy(weekdays: Omit<ILegacyTimer, "type" | "timeOn" | "timeOff">): {
        toShort(): ShortWeekdayEnum[];
        toLong(): LongWeekdayEnum[];
        toTimerWeekday(): TimerWeekday[];
    };
    fromTimerWeekday(weekdays: TimerWeekday[]): {
        toShort(): ShortWeekdayEnum[];
        toLegacy(): Omit<ILegacyTimer, "type" | "timeOn" | "timeOff">;
        toLong(): LongWeekdayEnum[];
    };
};
