"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDeviceBoundActionTypes = updateDeviceBoundActionTypes;
exports.popDevicePostponedActionIterator = popDevicePostponedActionIterator;
exports.pushDevicePostponedAction = pushDevicePostponedAction;
var _ = __importStar(require("lodash"));
var redisLock_1 = require("../../Redis/redisLock");
var debug_1 = __importDefault(require("debug"));
var debug = (0, debug_1.default)('@signageos/lib:Redis:DeviceActions:postponedDeviceActions');
/**
 * Update list of action types bound by a device and its particular socket name
 */
function updateDeviceBoundActionTypes(redisConnection, deviceUid, socketName, actionTypes) {
    return __awaiter(this, void 0, void 0, function () {
        var releaseLock, boundKey_1, prevActionTypes, newActionTypes_1, extraActionTypes_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, acquireDeviceLock(redisConnection, deviceUid, socketName)];
                case 1:
                    releaseLock = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 8, 10]);
                    boundKey_1 = getDeviceBoundActionTypesKey(deviceUid, socketName);
                    debug('set device bound action types', deviceUid, socketName, actionTypes);
                    return [4 /*yield*/, new Promise(function (resolve, reject) {
                            redisConnection.connection.smembers(boundKey_1, function (error, result) { return (error ? reject(error) : resolve(result)); });
                        })];
                case 3:
                    prevActionTypes = _a.sent();
                    newActionTypes_1 = _.difference(actionTypes, prevActionTypes);
                    if (!(newActionTypes_1.length > 0)) return [3 /*break*/, 5];
                    return [4 /*yield*/, new Promise(function (resolve, reject) {
                            redisConnection.connection.sadd(boundKey_1, newActionTypes_1, function (error) { return (error ? reject(error) : resolve()); });
                        })];
                case 4:
                    _a.sent();
                    _a.label = 5;
                case 5:
                    extraActionTypes_1 = _.difference(prevActionTypes, actionTypes);
                    if (!(extraActionTypes_1.length > 0)) return [3 /*break*/, 7];
                    return [4 /*yield*/, new Promise(function (resolve, reject) {
                            redisConnection.connection.srem(boundKey_1, extraActionTypes_1, function (error) { return (error ? reject(error) : resolve()); });
                        })];
                case 6:
                    _a.sent();
                    _a.label = 7;
                case 7: return [3 /*break*/, 10];
                case 8: return [4 /*yield*/, releaseLock()];
                case 9:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 10: return [2 /*return*/];
            }
        });
    });
}
function popDevicePostponedActionIterator(redisConnection, deviceUid, socketName) {
    return __asyncGenerator(this, arguments, function popDevicePostponedActionIterator_1() {
        var releaseLock, postponedKey_1, size, i, action, sizeAfterPop;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, __await(acquireDeviceLock(redisConnection, deviceUid, socketName))];
                case 1:
                    releaseLock = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 14, 16]);
                    debug('peak next device postponed action', deviceUid, socketName);
                    postponedKey_1 = getDevicePostponedActionsKey(deviceUid, socketName);
                    return [4 /*yield*/, __await(new Promise(function (resolve) {
                            redisConnection.connection.llen(postponedKey_1, function (error, length) { return (error ? resolve(0) : resolve(length)); });
                        }))];
                case 3:
                    size = _a.sent();
                    i = 0;
                    _a.label = 4;
                case 4:
                    if (!(i < size)) return [3 /*break*/, 10];
                    return [4 /*yield*/, __await(new Promise(function (resolve, reject) {
                            // get the next action from the list but don't pop it until it's succesfully processed
                            redisConnection.connection.lindex(postponedKey_1, 0, function (error, item) {
                                return error ? reject(error) : resolve(item ? JSON.parse(item) : null);
                            });
                        }))];
                case 5:
                    action = _a.sent();
                    debug('pop device postponed action', deviceUid, socketName, action);
                    if (!action) {
                        // If other process emptied list
                        return [3 /*break*/, 10];
                    }
                    return [4 /*yield*/, __await(action)];
                case 6: return [4 /*yield*/, _a.sent()];
                case 7:
                    _a.sent();
                    // now the action has been processed and we can pop it so it's removed from the list
                    return [4 /*yield*/, __await(new Promise(function (resolve, reject) {
                            redisConnection.connection.lpop(postponedKey_1, function (error) { return (error ? reject(error) : resolve()); });
                        }))];
                case 8:
                    // now the action has been processed and we can pop it so it's removed from the list
                    _a.sent();
                    _a.label = 9;
                case 9:
                    i++;
                    return [3 /*break*/, 4];
                case 10: return [4 /*yield*/, __await(new Promise(function (resolve) {
                        redisConnection.connection.llen(postponedKey_1, function (error, length) { return (error ? resolve(0) : resolve(length)); });
                    }))];
                case 11:
                    sizeAfterPop = _a.sent();
                    if (!(sizeAfterPop === 0)) return [3 /*break*/, 13];
                    return [4 /*yield*/, __await(new Promise(function (resolve, reject) {
                            redisConnection.connection.del(postponedKey_1, function (error) { return (error ? reject(error) : resolve()); });
                        }))];
                case 12:
                    _a.sent();
                    _a.label = 13;
                case 13: return [3 /*break*/, 16];
                case 14: return [4 /*yield*/, __await(releaseLock())];
                case 15:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 16: return [2 /*return*/];
            }
        });
    });
}
function pushDevicePostponedAction(redisConnection, deviceUid, action) {
    return __awaiter(this, void 0, void 0, function () {
        var socketNames, _i, socketNames_1, socketName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getSocketNamesWithBoundDeviceActionType(redisConnection, deviceUid, action.type)];
                case 1:
                    socketNames = _a.sent();
                    _i = 0, socketNames_1 = socketNames;
                    _a.label = 2;
                case 2:
                    if (!(_i < socketNames_1.length)) return [3 /*break*/, 5];
                    socketName = socketNames_1[_i];
                    return [4 /*yield*/, pushDevicePostponedActionToSocket(redisConnection, deviceUid, socketName, action)];
                case 3:
                    _a.sent();
                    _a.label = 4;
                case 4:
                    _i++;
                    return [3 /*break*/, 2];
                case 5: return [2 /*return*/];
            }
        });
    });
}
function getSocketNamesWithBoundDeviceActionType(redisConnection, deviceUid, actionType) {
    return __awaiter(this, void 0, void 0, function () {
        var boundKeys, boundKeyPrefix, boundSocketNames, _loop_1, _i, boundKeys_1, boundKey;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    debug('get socket names with bound device action type', deviceUid, actionType);
                    return [4 /*yield*/, new Promise(function (resolve, reject) {
                            var boundKeyPattern = getDeviceBoundActionTypesKey(deviceUid, '*');
                            redisConnection.connection.keys(boundKeyPattern, function (error, keys) { return (error ? reject(error) : resolve(keys)); });
                        })];
                case 1:
                    boundKeys = _a.sent();
                    boundKeyPrefix = getDeviceBoundActionTypesKey(deviceUid, '');
                    boundSocketNames = [];
                    _loop_1 = function (boundKey) {
                        var exists, socketName;
                        return __generator(this, function (_b) {
                            switch (_b.label) {
                                case 0: return [4 /*yield*/, new Promise(function (resolve, reject) {
                                        redisConnection.connection.sismember(boundKey, actionType, function (error, isMember) {
                                            return error ? reject(error) : resolve(isMember === 1);
                                        });
                                    })];
                                case 1:
                                    exists = _b.sent();
                                    if (exists) {
                                        socketName = boundKey.substr(boundKeyPrefix.length);
                                        boundSocketNames.push(socketName);
                                    }
                                    return [2 /*return*/];
                            }
                        });
                    };
                    _i = 0, boundKeys_1 = boundKeys;
                    _a.label = 2;
                case 2:
                    if (!(_i < boundKeys_1.length)) return [3 /*break*/, 5];
                    boundKey = boundKeys_1[_i];
                    return [5 /*yield**/, _loop_1(boundKey)];
                case 3:
                    _a.sent();
                    _a.label = 4;
                case 4:
                    _i++;
                    return [3 /*break*/, 2];
                case 5:
                    debug('got socket names with bound device action type', deviceUid, actionType, boundSocketNames);
                    return [2 /*return*/, boundSocketNames];
            }
        });
    });
}
function pushDevicePostponedActionToSocket(redisConnection, deviceUid, socketName, action) {
    return __awaiter(this, void 0, void 0, function () {
        var releaseLock, postponedKey_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, acquireDeviceLock(redisConnection, deviceUid, socketName)];
                case 1:
                    releaseLock = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 4, 6]);
                    postponedKey_2 = getDevicePostponedActionsKey(deviceUid, socketName);
                    return [4 /*yield*/, new Promise(function (resolve, reject) {
                            redisConnection.connection.rpush(postponedKey_2, JSON.stringify(action), function (error) { return (error ? reject(error) : resolve()); });
                        })];
                case 3:
                    _a.sent();
                    return [3 /*break*/, 6];
                case 4: return [4 /*yield*/, releaseLock()];
                case 5:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 6: return [2 /*return*/];
            }
        });
    });
}
function acquireDeviceLock(redisConnection, deviceUid, socketName) {
    var REDIS_LOCK_OPTIONS = {
        acquireTimeout: 10e3,
        releaseTimeout: 10e3,
        retryDelay: 200,
        prolongInterval: 1e3,
        ttlExtraTimeout: 2e3,
    };
    var acquireLock = (0, redisLock_1.redisLock)(redisConnection.connection);
    var lockKey = getDeviceLockKey(deviceUid, socketName);
    return acquireLock(lockKey, REDIS_LOCK_OPTIONS);
}
function getDeviceLockKey(deviceUid, socketName) {
    return "deviceLock.".concat(deviceUid, ".").concat(socketName);
}
function getDeviceBoundActionTypesKey(deviceUid, socketName) {
    // socketName has to be last because of redis prefix fetching
    return "deviceBoundActions.".concat(deviceUid, ".").concat(socketName);
}
function getDevicePostponedActionsKey(deviceUid, socketName) {
    // socketName has to be last because of redis prefix fetching
    return "devicePostponedActions.".concat(deviceUid, ".").concat(socketName);
}
//# sourceMappingURL=postponedDeviceActions.js.map