"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeferred = createDeferred;
function createDeferred(throwIfResolvedMultipleTimes) {
    var resolved = false;
    var _a = [undefined, undefined], promiseResolve = _a[0], promiseReject = _a[1];
    var promise = new Promise(function (resolve, reject) {
        var _a;
        _a = [resolve, reject], promiseResolve = _a[0], promiseReject = _a[1];
    });
    var handleIfIncorrect = function () {
        if (resolved) {
            if (throwIfResolvedMultipleTimes) {
                throw new Error("Deferred shouldn't be resolved more than once.");
            }
            else if (throwIfResolvedMultipleTimes === undefined) {
                // Print only warning for BC
                console.warn(new Error("Deferred shouldn't be resolved more than once, ignoring this call."));
            }
        }
        resolved = true;
    };
    return {
        promise: promise,
        resolve: function (value) {
            handleIfIncorrect();
            promiseResolve(value);
        },
        reject: function (e) {
            handleIfIncorrect();
            promiseReject(e);
        },
    };
}
//# sourceMappingURL=deferred.js.map