"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.processRPC = processRPC;
exports.enqueue = enqueue;
exports.enqueueNotification = enqueueNotification;
exports.enqueueToConsumer = enqueueToConsumer;
exports.fetchNext = fetchNext;
exports.fetchAll = fetchAll;
exports.bindMore = bindMore;
exports.bindRPC = bindRPC;
exports.bindMany = bindMany;
exports.bindRejectedMany = bindRejectedMany;
exports.fetchOneRejected = fetchOneRejected;
exports.bindRejectedDetached = bindRejectedDetached;
exports.fetchOneRejectedDetached = fetchOneRejectedDetached;
exports.bindOne = bindOne;
exports.bindOneExpectingConfirmation = bindOneExpectingConfirmation;
exports.purgeOne = purgeOne;
exports.deleteMore = deleteMore;
exports.prepareMore = prepareMore;
exports.prepareMany = prepareMany;
exports.prepareRejected = prepareRejected;
exports.prepareRejectedDetached = prepareRejectedDetached;
var fetchNextMessage_1 = __importDefault(require("../fetchNextMessage"));
var ChannelProvider_1 = require("../ChannelProvider");
var EXCHANGE_PREFIX = 'events';
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
var EXCHANGE_NOTIFICATIONS_PREFIX = 'events_notifications';
/** Alternate exchange for events (currently unused) */
var FAILED_EXCHANGE_NAME = 'events_failed';
/** Rejected exchange for (currently bindMany only) queues */
var REJECTED_EXCHANGE_NAME = 'events_rejected';
var OPTIONS = {
    persistent: true,
    confirmable: true,
    prefetchCount: 1,
};
var createEnqueueChannel = function (amqpConnection, event, exchangeName) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(event.type, OPTIONS)];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct')];
            case 2:
                _a.sent();
                return [4 /*yield*/, channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME })];
            case 3:
                _a.sent();
                return [2 /*return*/, channel];
        }
    });
}); }; };
var createBindChannel = function (amqpConnection, eventType, exchangeName, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(eventType, __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct')];
            case 2:
                _a.sent();
                return [4 /*yield*/, channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME })];
            case 3:
                _a.sent();
                return [2 /*return*/, channel];
        }
    });
}); }; };
var createRPCChannel = function (amqpConnection, domainName, options) {
    if (options === void 0) { options = {}; }
    return function () { return __awaiter(void 0, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel("rpc.".concat(domainName), __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
                case 1:
                    channel = _a.sent();
                    return [2 /*return*/, channel];
            }
        });
    }); };
};
var createBindManyChannel = function (amqpConnection, eventTypes, domainName, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel, _i, eventTypes_1, eventType, exchangeName;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(domainName, __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct')];
            case 2:
                _a.sent();
                _i = 0, eventTypes_1 = eventTypes;
                _a.label = 3;
            case 3:
                if (!(_i < eventTypes_1.length)) return [3 /*break*/, 6];
                eventType = eventTypes_1[_i];
                exchangeName = getExchangeName(options, eventType);
                return [4 /*yield*/, channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME })];
            case 4:
                _a.sent();
                _a.label = 5;
            case 5:
                _i++;
                return [3 /*break*/, 3];
            case 6: return [2 /*return*/, channel];
        }
    });
}); }; };
var createBindRejectedChannel = function (amqpConnection, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(REJECTED_EXCHANGE_NAME, __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(REJECTED_EXCHANGE_NAME, 'topic')];
            case 2:
                _a.sent();
                return [2 /*return*/, channel];
        }
    });
}); }; };
var createBindRejectedDetachedChannel = function (amqpConnection, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel('default', __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                // currently uses default exchange
                return [2 /*return*/, channel];
        }
    });
}); }; };
function processRPC(amqpConnection_1, domainName_1, consumerType_1, event_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, domainName, consumerType, event, messageOptions, headers) {
        var queueName, response;
        if (messageOptions === void 0) { messageOptions = {}; }
        if (headers === void 0) { headers = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRPCQueueName(consumerType, domainName);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueueExpectingResponse(createRPCChannel(amqpConnection, event.type), event, headers, '', // Default exchange and routingKey=queueName is used
                        queueName, messageOptions)];
                case 1:
                    response = _a.sent();
                    if (response.status === 'error') {
                        throw new Error("Event RPC processing failed: ".concat(response.error));
                    }
                    return [2 /*return*/];
            }
        });
    });
}
function enqueue(amqpConnection_1, event_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, event, messageOptions, headers) {
        var exchangeName;
        if (messageOptions === void 0) { messageOptions = {}; }
        if (headers === void 0) { headers = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName({ notification: false }, event.type);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createEnqueueChannel(amqpConnection, event, exchangeName), event, headers, exchangeName, getBasicEventRoutingKey(event.type), messageOptions)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
function enqueueNotification(amqpConnection, event) {
    return __awaiter(this, void 0, void 0, function () {
        var exchangeName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName({ notification: true }, event.type);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createEnqueueChannel(amqpConnection, event, exchangeName), event, undefined, exchangeName, getBasicEventRoutingKey(event.type), { persistent: false })];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function enqueueToConsumer(amqpConnection_1, event_1, consumerType_1, eventTypeOrDomainName_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, event, consumerType, eventTypeOrDomainName, messageOptions) {
        var queueName;
        var _this = this;
        if (messageOptions === void 0) { messageOptions = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getQueueName(consumerType, eventTypeOrDomainName !== null && eventTypeOrDomainName !== void 0 ? eventTypeOrDomainName : event.type);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(function () { return __awaiter(_this, void 0, void 0, function () {
                            var channel;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(event.type, OPTIONS)];
                                    case 1:
                                        channel = _a.sent();
                                        return [2 /*return*/, channel];
                                }
                            });
                        }); }, event, undefined, '', // default will auto route to queue with same name as routing key
                        queueName, // routingKey equal to queueName (specific consumer only)
                        messageOptions)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function fetchNext(amqpConnection_1, eventType_1, consumerType_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventType, consumerType, bindOptions, queueOptions, domainName) {
        var exchangeName, queueName, options;
        if (bindOptions === void 0) { bindOptions = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName(bindOptions, eventType);
                    queueName = getQueueName(consumerType, eventType);
                    options = __assign(__assign(__assign({}, queueOptions), bindOptions), (domainName ? getDomainConsumeOptions(bindOptions, consumerType, domainName) : getConsumeOptionsByBindOptions(bindOptions)));
                    return [4 /*yield*/, (0, fetchNextMessage_1.default)(amqpConnection, queueName, getBasicEventRoutingKey(eventType), exchangeName, FAILED_EXCHANGE_NAME, options, 'fanout', 'direct')];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
function fetchAll(amqpConnection_1, eventType_1, consumerType_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventType, consumerType, options) {
        var eventsCaught, doNext, event_1;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    eventsCaught = [];
                    doNext = false;
                    _a.label = 1;
                case 1: return [4 /*yield*/, fetchNext(amqpConnection, eventType, consumerType, options)];
                case 2:
                    event_1 = _a.sent();
                    if (event_1) {
                        doNext = true;
                        eventsCaught.push(event_1);
                    }
                    else {
                        doNext = false;
                    }
                    _a.label = 3;
                case 3:
                    if (doNext) return [3 /*break*/, 1];
                    _a.label = 4;
                case 4: return [2 /*return*/, eventsCaught];
            }
        });
    });
}
/**
 * @deprecated Use bindMany instead.
 * This methods only calls bindOne function for every eventType.
 * If you'd like to compose consumption of more event types into one queue, see the bindMany instead.
 */
function bindMore(amqpConnection_1, eventTypes_2, consumerType_1, onEvent_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventTypes, consumerType, onEvent, options) {
        var _i, eventTypes_3, eventType;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _i = 0, eventTypes_3 = eventTypes;
                    _a.label = 1;
                case 1:
                    if (!(_i < eventTypes_3.length)) return [3 /*break*/, 4];
                    eventType = eventTypes_3[_i];
                    return [4 /*yield*/, bindOne(amqpConnection, eventType, consumerType, onEvent, options)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    });
}
function bindRPC(amqpConnection_1, domainName_1, consumerType_1, onEvent_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, domainName, consumerType, onEvent, options) {
        var queueName, consumeOptions;
        var _this = this;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRPCQueueName(consumerType, domainName);
                    consumeOptions = getConsumeOptionsByBindOptions(options);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createRPCChannel(amqpConnection, domainName, options), queueName, [], // Default exchange and routingKey=queueName is used
                        function (event, headers) { return __awaiter(_this, void 0, void 0, function () {
                            var error_1;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 2, , 3]);
                                        return [4 /*yield*/, onEvent(event, headers)];
                                    case 1:
                                        _a.sent();
                                        return [2 /*return*/, { status: 'success' }];
                                    case 2:
                                        error_1 = _a.sent();
                                        return [2 /*return*/, {
                                                status: 'error',
                                                error: error_1.message,
                                            }];
                                    case 3: return [2 /*return*/];
                                }
                            });
                        }); }, __assign(__assign({}, consumeOptions), { respond: true }))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
/**
 * Bind more event types into one single queue.
 * This queue name contains specified domainName and is prefixed by consumerType.
 */
function bindMany(amqpConnection_1, eventTypes_2, domainName_1, consumerType_1, onEvent_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventTypes, domainName, consumerType, onEvent, options) {
        var queueName, bindings, consumeOptions;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getQueueName(consumerType, domainName);
                    bindings = eventTypes.map(function (eventType) {
                        var exchangeName = getExchangeName(options, eventType);
                        return { exchangeName: exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true };
                    });
                    consumeOptions = getDomainConsumeOptions(options, consumerType, domainName);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindManyChannel(amqpConnection, eventTypes, domainName, options), queueName, bindings, onEvent, consumeOptions)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
/**
 * Bind all events which were rejected with enqueue=false by bindMany function (the domain type only).
 */
function bindRejectedMany(amqpConnection_1, domainName_1, consumerType_1, onEvent_1, redeliverOptions_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, domainName, consumerType, onEvent, redeliverOptions, options) {
        var queueName;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedManyQueueName(consumerType, domainName);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindRejectedChannel(amqpConnection, options), queueName, [{ exchangeName: REJECTED_EXCHANGE_NAME, routingKey: getRejectedDomainRoutingKey(consumerType, domainName), persistent: true }], onEvent, getRejectedManyConsumeOptions(options, consumerType, domainName, redeliverOptions))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
/**
 * Fetch on event which were rejected with enqueue=false by bindMany function (the domain type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
function fetchOneRejected(amqpConnection, domainName, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var queueName, connection, channel, finish, message, event, originalQueueName, domain;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedManyQueueName(consumerType, domainName);
                    return [4 /*yield*/, amqpConnection.pool.acquire()];
                case 1:
                    connection = _a.sent();
                    return [4 /*yield*/, connection.createConfirmChannel()];
                case 2:
                    channel = _a.sent();
                    finish = function () { return __awaiter(_this, void 0, void 0, function () {
                        var error_2;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    _a.trys.push([0, 3, , 5]);
                                    return [4 /*yield*/, channel.close()];
                                case 1:
                                    _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.release(connection)];
                                case 2:
                                    _a.sent();
                                    return [3 /*break*/, 5];
                                case 3:
                                    error_2 = _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.destroy(connection)];
                                case 4:
                                    _a.sent();
                                    throw error_2;
                                case 5: return [2 /*return*/];
                            }
                        });
                    }); };
                    return [4 /*yield*/, channel.get(queueName)];
                case 3:
                    message = _a.sent();
                    if (!!message) return [3 /*break*/, 5];
                    return [4 /*yield*/, finish()];
                case 4:
                    _a.sent();
                    return [2 /*return*/, null];
                case 5:
                    event = amqpConnection.channelProvider.decodeMessageBuffer(message.content);
                    originalQueueName = message.properties.headers['x-first-death-queue'];
                    if (!!originalQueueName) return [3 /*break*/, 7];
                    return [4 /*yield*/, finish()];
                case 6:
                    _a.sent();
                    throw new Error("Message is missing original queue name \"x-first-death-queue\"");
                case 7:
                    domain = parseQueueName(consumerType, originalQueueName);
                    return [2 /*return*/, {
                            event: event,
                            domain: domain,
                            ack: function () {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.ack(message);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            nack: function (nackOptions) {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.nack(message, undefined, nackOptions === null || nackOptions === void 0 ? void 0 : nackOptions.requeue);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                        }];
            }
        });
    });
}
/**
 * Bind one event which were rejected with enqueue=false by bindOne function (the detached type only).
 */
function bindRejectedDetached(amqpConnection_1, eventType_1, consumerType_1, onEvent_1, redeliverOptions_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventType, consumerType, onEvent, redeliverOptions, bindOptions) {
        var queueName;
        if (bindOptions === void 0) { bindOptions = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedDetachedQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindRejectedDetachedChannel(amqpConnection, bindOptions), queueName, [
                            { exchangeName: '', routingKey: queueName, persistent: true }, // this is default binding defined by AMQP protocol
                        ], onEvent, getRejectedDetachedConsumeOptions(bindOptions, consumerType, eventType, redeliverOptions))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
/**
 * Fetch on event which were rejected with enqueue=false by bindOne function (the detached type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
function fetchOneRejectedDetached(amqpConnection, eventType, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var queueName, connection, channel, finish, message, event;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedDetachedQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.pool.acquire()];
                case 1:
                    connection = _a.sent();
                    return [4 /*yield*/, connection.createConfirmChannel()];
                case 2:
                    channel = _a.sent();
                    finish = function () { return __awaiter(_this, void 0, void 0, function () {
                        var error_3;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    _a.trys.push([0, 3, , 5]);
                                    return [4 /*yield*/, channel.close()];
                                case 1:
                                    _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.release(connection)];
                                case 2:
                                    _a.sent();
                                    return [3 /*break*/, 5];
                                case 3:
                                    error_3 = _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.destroy(connection)];
                                case 4:
                                    _a.sent();
                                    throw error_3;
                                case 5: return [2 /*return*/];
                            }
                        });
                    }); };
                    return [4 /*yield*/, channel.get(queueName)];
                case 3:
                    message = _a.sent();
                    if (!!message) return [3 /*break*/, 5];
                    return [4 /*yield*/, finish()];
                case 4:
                    _a.sent();
                    return [2 /*return*/, null];
                case 5:
                    event = amqpConnection.channelProvider.decodeMessageBuffer(message.content);
                    return [2 /*return*/, {
                            event: event,
                            ack: function () {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.ack(message);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            nack: function (nackOptions) {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.nack(message, undefined, nackOptions === null || nackOptions === void 0 ? void 0 : nackOptions.requeue);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                        }];
            }
        });
    });
}
function bindOne(amqpConnection_1, eventType_1, consumerType_1, onEvent_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventType, consumerType, onEvent, options) {
        var exchangeName, queueName;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName(options, eventType);
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindChannel(amqpConnection, eventType, exchangeName, options), queueName, [{ exchangeName: exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true }], onEvent, getConsumeOptionsByBindOptions(options))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
function bindOneExpectingConfirmation(amqpConnection_1, eventType_1, consumerType_1, onEvent_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventType, consumerType, onEvent, options) {
        var exchangeName, queueName;
        var _this = this;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName(options, eventType);
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(createBindChannel(amqpConnection, eventType, exchangeName, options), queueName, [{ exchangeName: exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true }], function (event, _headers, ack, nack) { return __awaiter(_this, void 0, void 0, function () {
                            var ackAsync;
                            var _this = this;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        ackAsync = function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                            return [2 /*return*/, ack()];
                                        }); }); };
                                        return [4 /*yield*/, onEvent(event, ackAsync, nack)];
                                    case 1:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); }, getConsumeOptionsByBindOptions(options))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
function purgeOne(amqpConnection, eventType, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var queueName, channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.channelProvider.getChannel(eventType)];
                case 1:
                    channel = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 4, 6]);
                    return [4 /*yield*/, channel.purge(queueName)];
                case 3:
                    _a.sent();
                    return [3 /*break*/, 6];
                case 4: return [4 /*yield*/, channel.close()];
                case 5:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 6: return [2 /*return*/];
            }
        });
    });
}
function deleteMore(amqpConnection, eventTypes, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var _i, eventTypes_2, eventType, queueName, channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _i = 0, eventTypes_2 = eventTypes;
                    _a.label = 1;
                case 1:
                    if (!(_i < eventTypes_2.length)) return [3 /*break*/, 8];
                    eventType = eventTypes_2[_i];
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.channelProvider.getChannel(eventType)];
                case 2:
                    channel = _a.sent();
                    _a.label = 3;
                case 3:
                    _a.trys.push([3, , 5, 7]);
                    return [4 /*yield*/, channel.delete(queueName)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 5: return [4 /*yield*/, channel.close()];
                case 6:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 7:
                    _i++;
                    return [3 /*break*/, 1];
                case 8: return [2 /*return*/];
            }
        });
    });
}
function prepareMore(amqpConnection_1, events_1, consumerType_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, events, consumerType, options) {
        var _i, events_2, event_2;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _i = 0, events_2 = events;
                    _a.label = 1;
                case 1:
                    if (!(_i < events_2.length)) return [3 /*break*/, 4];
                    event_2 = events_2[_i];
                    // Hack to create event queue for exchange
                    return [4 /*yield*/, fetchNext(amqpConnection, event_2, consumerType, options)];
                case 2:
                    // Hack to create event queue for exchange
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    });
}
function prepareMany(amqpConnection_1, events_1, domainName_1, consumerType_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, events, domainName, consumerType, options) {
        var cancel, close;
        var _this = this;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, bindMany(amqpConnection, events, domainName, consumerType, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                        return [2 /*return*/, new Promise(function () { return undefined; })];
                    }); }); }, options)];
                case 1:
                    cancel = _a.sent();
                    return [4 /*yield*/, cancel()];
                case 2:
                    close = _a.sent();
                    return [4 /*yield*/, close()];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function prepareRejected(amqpConnection_1, domainName_1, consumerType_1, redeliverOptions_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, domainName, consumerType, redeliverOptions, options) {
        var cancel, close;
        var _this = this;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, bindRejectedMany(amqpConnection, domainName, consumerType, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                        return [2 /*return*/, new Promise(function () { return undefined; })];
                    }); }); }, redeliverOptions, options)];
                case 1:
                    cancel = _a.sent();
                    return [4 /*yield*/, cancel()];
                case 2:
                    close = _a.sent();
                    return [4 /*yield*/, close()];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function prepareRejectedDetached(amqpConnection_1, eventType_1, consumerType_1, redeliverOptions_1) {
    return __awaiter(this, arguments, void 0, function (amqpConnection, eventType, consumerType, redeliverOptions, bindOptions) {
        var cancel, close;
        var _this = this;
        if (bindOptions === void 0) { bindOptions = {}; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, bindRejectedDetached(amqpConnection, eventType, consumerType, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                        return [2 /*return*/, new Promise(function () { return undefined; })];
                    }); }); }, redeliverOptions, bindOptions)];
                case 1:
                    cancel = _a.sent();
                    return [4 /*yield*/, cancel()];
                case 2:
                    close = _a.sent();
                    return [4 /*yield*/, close()];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function getDomainConsumeOptions(options, consumerType, domainName) {
    return __assign(__assign({}, getConsumeOptionsByBindOptions(options)), { deadLetterExchange: REJECTED_EXCHANGE_NAME, deadLetterRoutingKey: getRejectedDomainRoutingKey(consumerType, domainName) });
}
function getRejectedManyConsumeOptions(bindOptions, consumerType, domainName, redeliverOptions) {
    var queueName = getQueueName(consumerType, domainName);
    return __assign(__assign({}, getConsumeOptionsByBindOptions(bindOptions)), { deadLetterExchange: '', deadLetterRoutingKey: queueName, messageExpiresMs: redeliverOptions.redeliverDelayMs, queueType: 'classic' });
}
function getRejectedDetachedConsumeOptions(bindOptions, consumerType, eventType, redeliverOptions) {
    var queueName = getQueueName(consumerType, eventType);
    return __assign(__assign({}, getConsumeOptionsByBindOptions(bindOptions)), { deadLetterExchange: '', deadLetterRoutingKey: queueName, messageExpiresMs: redeliverOptions.redeliverDelayMs, queueType: 'classic' });
}
function getConsumeOptionsByBindOptions(options) {
    return {
        autoDelete: typeof options.persistent !== 'undefined' ? !options.persistent : false,
        exclusive: typeof options.exclusive !== 'undefined' ? options.exclusive : false,
        redeliverDelayMs: typeof options.redeliverDelayMs !== 'undefined' ? options.redeliverDelayMs : 1e3,
        suppressFirstError: typeof options.suppressFirstError !== 'undefined' ? options.suppressFirstError : true,
        singleActiveConsumer: options.singleActiveConsumer,
        deadLetterIfRedeliveredAndErred: options.deadLetterIfRedeliveredAndErred,
        deadLetterIfErred: options.deadLetterIfErred,
        queueType: typeof options.queueType !== 'undefined' ? options.queueType : 'quorum', // default for event queues are swapped
        durable: typeof options.durable !== 'undefined' ? options.durable : true,
        maxLength: typeof options.maxLength !== 'undefined' ? options.maxLength : undefined,
        overflow: typeof options.overflow !== 'undefined' ? options.overflow : undefined,
    };
}
function getExchangeName(options, eventType) {
    var prefix = options.notification ? EXCHANGE_NOTIFICATIONS_PREFIX : EXCHANGE_PREFIX;
    return "".concat(prefix, "-").concat(eventType);
}
function getQueueName(consumerType, eventTypeOrDomainName) {
    return consumerType + '_' + eventTypeOrDomainName;
}
function getRPCQueueName(consumerType, domainName) {
    return consumerType + '_' + domainName + '.rpc';
}
function parseQueueName(consumerType, queueName) {
    var eventTypeOrDomainName = queueName.substring(consumerType.length + 1);
    var expectedQueueName = getQueueName(consumerType, eventTypeOrDomainName);
    if (expectedQueueName !== queueName) {
        throw new Error("Incorrect queue name cannot be parsed: ".concat(consumerType, ", ").concat(queueName));
    }
    return eventTypeOrDomainName;
}
function getRejectedManyQueueName(consumerType, domainName) {
    return 'events_rejected.' + getQueueName(consumerType, domainName);
}
function getRejectedDetachedQueueName(consumerType, eventType) {
    return ChannelProvider_1.REJECTED_QUEUE_PREFIX + getQueueName(consumerType, eventType);
}
function escapeEventTypeForRoutingKey(eventType) {
    return eventType.replace(/\./g, '_');
}
function getBasicEventRoutingKey(eventType) {
    return 'event.' + escapeEventTypeForRoutingKey(eventType);
}
function getRejectedDomainRoutingKey(consumerType, domainName) {
    return 'domain.' + consumerType + '.' + domainName;
}
//# sourceMappingURL=eventQueue.js.map