"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeferredState = void 0;
var deferred_1 = require("../../../Promise/deferred");
var debug_1 = __importDefault(require("debug"));
var debug = (0, debug_1.default)('@signageos/lib:AMQP:EventSourcing:Locked:deferredState');
/**
 * DeferredState is a helper class for managing deferred promises for the LockedEventConsumer.
 * It allows to manage internal map of deferred promises for each lock-key.
 */
var DeferredState = /** @class */ (function () {
    function DeferredState() {
        this.deferredMap = new Map();
    }
    /**
     * Create a deferred for the current lock-keys and push it to the list for subsequent promises to wait on.
     */
    DeferredState.prototype.addDeferred = function (lockKeys) {
        var _a;
        debug('Adding deferred for lock-keys', { lockKeys: lockKeys });
        var currentDeferred = (0, deferred_1.createDeferred)(true);
        for (var _i = 0, lockKeys_1 = lockKeys; _i < lockKeys_1.length; _i++) {
            var lockKey = lockKeys_1[_i];
            var listOfDeferred = (_a = this.deferredMap.get(lockKey)) !== null && _a !== void 0 ? _a : [];
            this.deferredMap.set(lockKey, listOfDeferred);
            listOfDeferred.push(currentDeferred);
        }
        return currentDeferred;
    };
    /**
     * Remove the deferred from the list for the given lock-keys.
     * If the list becomes empty, remove it from the map (cleanup).
     */
    DeferredState.prototype.removeDeferred = function (lockKeys, deferred) {
        var _a;
        debug('Removing deferred for lock-keys', { lockKeys: lockKeys });
        for (var _i = 0, lockKeys_2 = lockKeys; _i < lockKeys_2.length; _i++) {
            var lockKey = lockKeys_2[_i];
            var listOfDeferred = (_a = this.deferredMap.get(lockKey)) !== null && _a !== void 0 ? _a : [];
            var index = listOfDeferred.indexOf(deferred);
            if (index !== -1) {
                listOfDeferred.splice(index, 1);
            }
            if (listOfDeferred.length === 0) {
                this.deferredMap.delete(lockKey);
            }
        }
    };
    /**
     * Get a list of promises for all previously created deferred with the same lock-keys.
     */
    DeferredState.prototype.getPreviousPromises = function (lockKeys) {
        var _a;
        var promises = [];
        for (var _i = 0, lockKeys_3 = lockKeys; _i < lockKeys_3.length; _i++) {
            var lockKey = lockKeys_3[_i];
            var listOfDeferred = (_a = this.deferredMap.get(lockKey)) !== null && _a !== void 0 ? _a : [];
            for (var _b = 0, listOfDeferred_1 = listOfDeferred; _b < listOfDeferred_1.length; _b++) {
                var deferred = listOfDeferred_1[_b];
                promises.push(deferred.promise);
            }
        }
        debug('Getting previous promises for lock-keys', { lockKeys: lockKeys, count: promises.length });
        return promises;
    };
    return DeferredState;
}());
exports.DeferredState = DeferredState;
//# sourceMappingURL=deferredState.js.map