"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_QUORUM_INITIAL_GROUP_SIZE = exports.REJECTED_QUEUE_PREFIX = void 0;
var _ = __importStar(require("lodash"));
var jsonHelper_1 = require("../JSON/jsonHelper");
var debug_1 = __importDefault(require("debug"));
var amqpErrors_1 = require("./amqpErrors");
var wait_1 = __importDefault(require("../Timer/wait"));
var lockedDecorator_1 = require("../Lock/lockedDecorator");
var timeout_1 = require("../Timer/timeout");
var errors_1 = require("./errors");
var ResponseProvider_1 = require("./ResponseProvider");
var debug = (0, debug_1.default)('@signageos/lib:AMQP:ChannelProvider');
var MAX_PENDING_TASKS = 100e3;
var CHANNEL_IDLE_TIMEOUT_SECONDS = 20;
var DEFAULT_PREFETCH_COUNT = 100;
exports.REJECTED_QUEUE_PREFIX = '__rejected.';
exports.DEFAULT_QUORUM_INITIAL_GROUP_SIZE = 3;
var ChannelProvider = /** @class */ (function () {
    function ChannelProvider(amqpPool) {
        this.amqpPool = amqpPool;
        this.decodeMessageBuffer = function (encodedMessageBuffer) {
            return (encodedMessageBuffer === null || encodedMessageBuffer === void 0 ? void 0 : encodedMessageBuffer.toString()) ? JSON.parse(encodedMessageBuffer.toString(), jsonHelper_1.deserializeJSON) : null;
        };
        this.amqplibChannelMap = {};
        this.responseProviderMap = {};
    }
    ChannelProvider.prototype.getChannel = function (namespace_1) {
        return __awaiter(this, arguments, void 0, function (namespace, options) {
            var amqplibConnection, amqplibChannel, responseProvider, channel;
            var _this = this;
            if (options === void 0) { options = {}; }
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getAmqplibConnection()];
                    case 1:
                        amqplibConnection = _a.sent();
                        if (!options.confirmable) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.getAmqplibConfirmChannel(amqplibConnection, namespace)];
                    case 2:
                        amqplibChannel = _a.sent();
                        return [3 /*break*/, 5];
                    case 3: return [4 /*yield*/, this.getAmqplibChannel(amqplibConnection, namespace)];
                    case 4:
                        amqplibChannel = _a.sent();
                        _a.label = 5;
                    case 5:
                        responseProvider = this.getResponseProvider(amqplibConnection, namespace);
                        channel = {
                            assertExchange: function (exchangeName, type, exchangeOptions) { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4 /*yield*/, amqplibChannel.assertExchange(exchangeName, type, exchangeOptions)];
                                        case 1:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); },
                            send: function (message_1) {
                                var args_1 = [];
                                for (var _i = 1; _i < arguments.length; _i++) {
                                    args_1[_i - 1] = arguments[_i];
                                }
                                return __awaiter(_this, __spreadArray([message_1], args_1, true), void 0, function (message, messageOptions, headers, exchangeName, routingKey) {
                                    var encodedMessageBuffer, amqplibSendOptions;
                                    if (messageOptions === void 0) { messageOptions = {}; }
                                    if (headers === void 0) { headers = {}; }
                                    if (exchangeName === void 0) { exchangeName = ''; }
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                encodedMessageBuffer = this.encodeMessageIntoBuffer(message);
                                                amqplibSendOptions = this.createAmqplibSendOptions(options, messageOptions, headers);
                                                return [4 /*yield*/, this.publish(amqplibChannel, exchangeName, routingKey, encodedMessageBuffer, amqplibSendOptions, options)];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            sendExpectingResponse: function (message_1) {
                                var args_1 = [];
                                for (var _i = 1; _i < arguments.length; _i++) {
                                    args_1[_i - 1] = arguments[_i];
                                }
                                return __awaiter(_this, __spreadArray([message_1], args_1, true), void 0, function (message, messageOptions, headers, exchangeName, routingKey, responseTimeout) {
                                    var encodedMessageBuffer, response, amqplibSendOptions, responsePromises, timeoutPromise, error_1;
                                    if (messageOptions === void 0) { messageOptions = {}; }
                                    if (headers === void 0) { headers = {}; }
                                    if (exchangeName === void 0) { exchangeName = ''; }
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                encodedMessageBuffer = this.encodeMessageIntoBuffer(message);
                                                _a.label = 1;
                                            case 1:
                                                _a.trys.push([1, 5, , 6]);
                                                return [4 /*yield*/, responseProvider.prepareResponse()];
                                            case 2:
                                                response = _a.sent();
                                                amqplibSendOptions = __assign(__assign({}, this.createAmqplibSendOptions(options, messageOptions, headers)), { replyTo: response.queueName, correlationId: response.correlationId });
                                                return [4 /*yield*/, this.publish(amqplibChannel, exchangeName, routingKey, encodedMessageBuffer, amqplibSendOptions, options)];
                                            case 3:
                                                _a.sent();
                                                responsePromises = [response.promise];
                                                if (typeof responseTimeout !== 'undefined') {
                                                    timeoutPromise = (0, timeout_1.rejectAfterTimeout)(responseTimeout);
                                                    responsePromises.push(timeoutPromise);
                                                }
                                                return [4 /*yield*/, Promise.race(responsePromises)];
                                            case 4: return [2 /*return*/, _a.sent()];
                                            case 5:
                                                error_1 = _a.sent();
                                                if (error_1 instanceof timeout_1.TimeoutError) {
                                                    throw new errors_1.ResponseTimeoutError();
                                                }
                                                else {
                                                    throw error_1;
                                                }
                                                return [3 /*break*/, 6];
                                            case 6: return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            consumeSimple: function (queueName_1, bindings_1, onMessage_1) {
                                var args_1 = [];
                                for (var _i = 3; _i < arguments.length; _i++) {
                                    args_1[_i - 3] = arguments[_i];
                                }
                                return __awaiter(_this, __spreadArray([queueName_1, bindings_1, onMessage_1], args_1, true), void 0, function (queueName, bindings, onMessage, consumeOptions, onEnded) {
                                    var _this = this;
                                    if (consumeOptions === void 0) { consumeOptions = {}; }
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0: return [4 /*yield*/, channel.consume(queueName, bindings, function (message, headers, ack, nack, fields) { return __awaiter(_this, void 0, void 0, function () {
                                                    var response, error_2, requeue;
                                                    return __generator(this, function (_a) {
                                                        switch (_a.label) {
                                                            case 0:
                                                                _a.trys.push([0, 2, , 3]);
                                                                return [4 /*yield*/, onMessage(message, headers)];
                                                            case 1:
                                                                response = _a.sent();
                                                                ack();
                                                                return [2 /*return*/, response];
                                                            case 2:
                                                                error_2 = _a.sent();
                                                                requeue = !this.shouldDeadLetter(consumeOptions, fields.redelivered);
                                                                nack({ requeue: requeue });
                                                                if (!consumeOptions.suppressFirstError || fields.redelivered) {
                                                                    throw error_2;
                                                                }
                                                                return [3 /*break*/, 3];
                                                            case 3: return [2 /*return*/];
                                                        }
                                                    });
                                                }); }, consumeOptions, onEnded)];
                                            case 1: return [2 /*return*/, _a.sent()];
                                        }
                                    });
                                });
                            },
                            assertRejectableQueue: function (queueName_1) {
                                var args_1 = [];
                                for (var _i = 1; _i < arguments.length; _i++) {
                                    args_1[_i - 1] = arguments[_i];
                                }
                                return __awaiter(_this, __spreadArray([queueName_1], args_1, true), void 0, function (queueName, consumeOptions) {
                                    if (consumeOptions === void 0) { consumeOptions = {}; }
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0: return [4 /*yield*/, this.assertRejectableQueue(amqplibChannel, queueName, options, consumeOptions)];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            consume: function (queueName_1, bindings_1, onMessage_1) {
                                var args_1 = [];
                                for (var _i = 3; _i < arguments.length; _i++) {
                                    args_1[_i - 3] = arguments[_i];
                                }
                                return __awaiter(_this, __spreadArray([queueName_1, bindings_1, onMessage_1], args_1, true), void 0, function (queueName, bindings, onMessage, consumeOptions, onEnded) {
                                    var onEndedCallback, amqplibConsumeOptions, uniqueConsumerTagName, consumerTag_1, error_3;
                                    var _this = this;
                                    if (consumeOptions === void 0) { consumeOptions = {}; }
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                onEndedCallback = function () {
                                                    if (onEnded) {
                                                        onEnded();
                                                        onEnded = undefined;
                                                    }
                                                };
                                                return [4 /*yield*/, amqplibChannel.prefetch(options.prefetchCount || DEFAULT_PREFETCH_COUNT)];
                                            case 1:
                                                _a.sent();
                                                return [4 /*yield*/, this.assertRejectableQueue(amqplibChannel, queueName, options, consumeOptions)];
                                            case 2:
                                                _a.sent();
                                                amqplibConsumeOptions = {};
                                                if (consumeOptions.exclusiveConsumption) {
                                                    uniqueConsumerTagName = "amqp.ctag-".concat(queueName);
                                                    amqplibConsumeOptions.consumerTag = uniqueConsumerTagName; // This will prevent have more than one consumption on queue
                                                }
                                                if (consumeOptions.noAck) {
                                                    amqplibConsumeOptions.noAck = true;
                                                }
                                                _a.label = 3;
                                            case 3:
                                                _a.trys.push([3, 6, , 7]);
                                                return [4 /*yield*/, amqplibChannel.consume(queueName, function (amqplibMessage) { return __awaiter(_this, void 0, void 0, function () {
                                                        var sendResponse, message, response;
                                                        return __generator(this, function (_a) {
                                                            switch (_a.label) {
                                                                case 0:
                                                                    if (amqplibMessage === null) {
                                                                        onEndedCallback(); // consumption canceled unexpectedly
                                                                        amqplibChannel.removeListener('close', onEndedCallback);
                                                                        return [2 /*return*/];
                                                                    }
                                                                    if (!(consumeOptions.redeliverDelayMs && amqplibMessage.fields.redelivered)) return [3 /*break*/, 2];
                                                                    return [4 /*yield*/, (0, wait_1.default)(consumeOptions.redeliverDelayMs)];
                                                                case 1:
                                                                    _a.sent();
                                                                    _a.label = 2;
                                                                case 2:
                                                                    sendResponse = true;
                                                                    message = this.decodeMessageBuffer(amqplibMessage.content);
                                                                    return [4 /*yield*/, onMessage(message, amqplibMessage.properties.headers, function () {
                                                                            if (!consumeOptions.noAck) {
                                                                                amqplibChannel.ack(amqplibMessage);
                                                                            }
                                                                        }, function (nackOptions) {
                                                                            if (!consumeOptions.noAck) {
                                                                                amqplibChannel.nack(amqplibMessage, undefined, nackOptions ? nackOptions.requeue : undefined);
                                                                            }
                                                                            sendResponse = false;
                                                                        }, amqplibMessage.fields)];
                                                                case 3:
                                                                    response = _a.sent();
                                                                    if (sendResponse && consumeOptions.respond && amqplibMessage.properties.replyTo) {
                                                                        amqplibChannel.sendToQueue(amqplibMessage.properties.replyTo, this.encodeMessageIntoBuffer(response), {
                                                                            correlationId: amqplibMessage.properties.correlationId,
                                                                        });
                                                                    }
                                                                    return [2 /*return*/];
                                                            }
                                                        });
                                                    }); }, amqplibConsumeOptions)];
                                            case 4:
                                                consumerTag_1 = (_a.sent()).consumerTag;
                                                return [4 /*yield*/, Promise.all(bindings.map(function (binding) {
                                                        return _this.bindQueue(amqplibChannel, queueName, binding.exchangeName, binding.routingKey || '', binding.routingHeaders);
                                                    }))];
                                            case 5:
                                                _a.sent();
                                                amqplibChannel.once('close', onEndedCallback);
                                                return [2 /*return*/, function () { return __awaiter(_this, void 0, void 0, function () {
                                                        var message;
                                                        var _this = this;
                                                        return __generator(this, function (_a) {
                                                            switch (_a.label) {
                                                                case 0:
                                                                    amqplibChannel.removeListener('close', onEndedCallback);
                                                                    return [4 /*yield*/, Promise.all(bindings.map(function (binding) { return __awaiter(_this, void 0, void 0, function () {
                                                                            return __generator(this, function (_a) {
                                                                                switch (_a.label) {
                                                                                    case 0:
                                                                                        if (!!binding.persistent) return [3 /*break*/, 2];
                                                                                        return [4 /*yield*/, this.unbindQueue(amqplibChannel, queueName, binding.exchangeName, binding.routingKey || '', binding.routingHeaders)];
                                                                                    case 1:
                                                                                        _a.sent();
                                                                                        _a.label = 2;
                                                                                    case 2: return [2 /*return*/];
                                                                                }
                                                                            });
                                                                        }); }))];
                                                                case 1:
                                                                    _a.sent();
                                                                    if (!('autoDeleteDeadLetter' in consumeOptions && consumeOptions.autoDeleteDeadLetter)) return [3 /*break*/, 6];
                                                                    message = void 0;
                                                                    _a.label = 2;
                                                                case 2: return [4 /*yield*/, amqplibChannel.get(queueName)];
                                                                case 3:
                                                                    if (!(message = _a.sent())) return [3 /*break*/, 4];
                                                                    // requeue=false will dead-letter message even if whole queue is deleted later
                                                                    amqplibChannel.nack(message, undefined, false);
                                                                    return [3 /*break*/, 2];
                                                                case 4: return [4 /*yield*/, amqplibChannel.deleteQueue(queueName)];
                                                                case 5:
                                                                    _a.sent();
                                                                    _a.label = 6;
                                                                case 6: 
                                                                // cancel has to be last to prevent conflicting with other consumer
                                                                return [4 /*yield*/, amqplibChannel.cancel(consumerTag_1)];
                                                                case 7:
                                                                    // cancel has to be last to prevent conflicting with other consumer
                                                                    _a.sent();
                                                                    return [2 /*return*/];
                                                            }
                                                        });
                                                    }); }];
                                            case 6:
                                                error_3 = _a.sent();
                                                throw new amqpErrors_1.ConsumptionError("Could not start consumption on queue", queueName, error_3);
                                            case 7: return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            unbind: function (queueName, binding) { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4 /*yield*/, this.unbindQueue(amqplibChannel, queueName, binding.exchangeName, binding.routingKey || '', binding.routingHeaders)];
                                        case 1:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); },
                            get: function (queueName) { return __awaiter(_this, void 0, void 0, function () {
                                var amqplibMessage, message;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4 /*yield*/, amqplibChannel.get(queueName)];
                                        case 1:
                                            amqplibMessage = (_a.sent());
                                            if (amqplibMessage) {
                                                message = this.decodeMessageBuffer(amqplibMessage.content);
                                                return [2 /*return*/, {
                                                        headers: amqplibMessage.properties.headers,
                                                        message: message,
                                                        ack: function () { return amqplibChannel.ack(amqplibMessage); },
                                                        nack: function (nackOptions) {
                                                            return amqplibChannel.nack(amqplibMessage, undefined, nackOptions ? nackOptions.requeue : undefined);
                                                        },
                                                    }];
                                            }
                                            else {
                                                return [2 /*return*/, null];
                                            }
                                            return [2 /*return*/];
                                    }
                                });
                            }); },
                            purge: function (queueName) { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4 /*yield*/, amqplibChannel.purgeQueue(queueName)];
                                        case 1:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); },
                            delete: function (queueName) { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4 /*yield*/, amqplibChannel.deleteQueue(queueName)];
                                        case 1:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); },
                            close: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            if (!options.confirmable) return [3 /*break*/, 2];
                                            return [4 /*yield*/, this.closeAmqplibConfirmChannel(namespace)];
                                        case 1:
                                            _a.sent();
                                            return [3 /*break*/, 4];
                                        case 2: return [4 /*yield*/, this.closeAmqplibChannel(namespace)];
                                        case 3:
                                            _a.sent();
                                            _a.label = 4;
                                        case 4: return [2 /*return*/];
                                    }
                                });
                            }); },
                        };
                        return [2 /*return*/, channel];
                }
            });
        });
    };
    ChannelProvider.prototype.shouldDeadLetter = function (consumeOptions, redelivered) {
        if (consumeOptions.deadLetterIfRedeliveredAndErred && redelivered) {
            return true;
        }
        if (consumeOptions.deadLetterIfErred) {
            return true;
        }
        return false;
    };
    ChannelProvider.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () {
            var amqplibConnection;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getAmqplibConnection()];
                    case 1:
                        amqplibConnection = _a.sent();
                        return [4 /*yield*/, this.amqpPool.destroy(amqplibConnection)];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    ChannelProvider.prototype.encodeMessageIntoBuffer = function (message) {
        return Buffer.from(typeof message !== 'undefined' ? JSON.stringify(message) : '');
    };
    ChannelProvider.prototype.getAmqplibConnection = function () {
        return __awaiter(this, void 0, void 0, function () {
            var amqplibConnection;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!!this.amqplibConnection) return [3 /*break*/, 2];
                        debug('Create connection');
                        return [4 /*yield*/, this.amqpPool.acquire()];
                    case 1:
                        amqplibConnection = _a.sent();
                        debug('Created connection');
                        amqplibConnection.on('close', function () {
                            debug('Closed connection');
                            _this.amqplibConnection = undefined;
                            _this.amqplibChannelMap = {};
                        });
                        this.amqplibConnection = amqplibConnection;
                        _a.label = 2;
                    case 2: return [2 /*return*/, this.amqplibConnection];
                }
            });
        });
    };
    ChannelProvider.prototype.createAmqplibSendOptions = function (options, messageOptions, headers) {
        return {
            persistent: typeof messageOptions.persistent !== 'undefined' ? messageOptions.persistent : options.persistent,
            priority: messageOptions.priority,
            expiration: messageOptions.expiration,
            headers: headers,
        };
    };
    ChannelProvider.prototype.publish = function (amqplibChannel, exchangeName, routingKey, encodedMessageBuffer, sendOptions, options) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!options.confirmable) return [3 /*break*/, 2];
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                return amqplibChannel.publish(exchangeName, routingKey, encodedMessageBuffer, sendOptions, function (error) {
                                    return error !== null ? reject(error) : resolve();
                                });
                            })];
                    case 1:
                        _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        amqplibChannel.publish(exchangeName, routingKey, encodedMessageBuffer, sendOptions);
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    ChannelProvider.prototype.getAmqplibChannel = function (amqplibConnection, identifier) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getOrCreateAmqplibChannel('not_confirm-' + identifier, function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, amqplibConnection.createChannel()];
                                    case 1: return [2 /*return*/, _a.sent()];
                                }
                            });
                        }); })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    ChannelProvider.prototype.getAmqplibConfirmChannel = function (amqplibConnection, identifier) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getOrCreateAmqplibChannel('confirm-' + identifier, function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, amqplibConnection.createConfirmChannel()];
                                    case 1: return [2 /*return*/, _a.sent()];
                                }
                            });
                        }); })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    ChannelProvider.prototype.closeAmqplibChannel = function (identifier) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.releaseAmqplibChannel('not_confirm-' + identifier)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    ChannelProvider.prototype.closeAmqplibConfirmChannel = function (identifier) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.releaseAmqplibChannel('confirm-' + identifier)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    ChannelProvider.prototype.getOrCreateAmqplibChannel = function (identifier, createChannel) {
        return __awaiter(this, void 0, void 0, function () {
            var amqplibChannel_1;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(this.amqplibChannelMap[identifier] === undefined)) return [3 /*break*/, 2];
                        debug('Create channel %s', identifier);
                        return [4 /*yield*/, createChannel()];
                    case 1:
                        amqplibChannel_1 = _a.sent();
                        amqplibChannel_1.setMaxListeners(100);
                        debug('Created channel %s', identifier);
                        amqplibChannel_1.once('error', function (error) {
                            debug('Channel error, closing immediately', identifier, error);
                            // When channel has error, it's automatically closed
                            delete _this.amqplibChannelMap[identifier];
                            amqplibChannel_1.close().catch(function (closeError) { return console.warn("Could not close erred channel", closeError); });
                        });
                        this.amqplibChannelMap[identifier] = {
                            channel: amqplibChannel_1,
                            clientCount: 0,
                            closeAfterAWhile: _.debounce(function () { return _this.tryCloseAmqplibChannelWhenUnused(identifier); }, CHANNEL_IDLE_TIMEOUT_SECONDS * 1000),
                        };
                        _a.label = 2;
                    case 2:
                        this.amqplibChannelMap[identifier].clientCount++;
                        this.amqplibChannelMap[identifier].closeAfterAWhile.cancel();
                        return [2 /*return*/, this.amqplibChannelMap[identifier].channel];
                }
            });
        });
    };
    ChannelProvider.prototype.releaseAmqplibChannel = function (identifier) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (typeof this.amqplibChannelMap[identifier] !== 'undefined') {
                    this.amqplibChannelMap[identifier].clientCount--;
                    this.amqplibChannelMap[identifier].closeAfterAWhile();
                }
                else {
                    console.log('Unexpected close channel to non-existent channel ' + identifier);
                }
                return [2 /*return*/];
            });
        });
    };
    ChannelProvider.prototype.tryCloseAmqplibChannelWhenUnused = function (identifier) {
        if (typeof this.amqplibChannelMap[identifier] !== 'undefined') {
            if (this.amqplibChannelMap[identifier].clientCount <= 0) {
                var channel = this.amqplibChannelMap[identifier].channel;
                delete this.amqplibChannelMap[identifier];
                channel.close().catch(function (error) { return console.warn("Could not closed idle channel", error); });
            }
        }
        if (this.responseProviderMap[identifier]) {
            var responseProvider = this.responseProviderMap[identifier];
            delete this.responseProviderMap[identifier];
            responseProvider.close().catch(function (error) { return console.warn("Could not close idle responseProvider", error); });
        }
    };
    ChannelProvider.prototype.getResponseProvider = function (amqplibConnection, identifier) {
        if (!this.responseProviderMap[identifier]) {
            var responseProvider = new ResponseProvider_1.ResponseProvider(amqplibConnection, this.decodeMessageBuffer);
            this.responseProviderMap[identifier] = responseProvider;
        }
        return this.responseProviderMap[identifier];
    };
    ChannelProvider.prototype.assertRejectableQueue = function (amqplibChannel, queueName, queueOptions, consumeOptions) {
        return __awaiter(this, void 0, void 0, function () {
            var extraArguments;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        extraArguments = {};
                        if (consumeOptions.queueExpiresMs) {
                            // x-expires is only feature of RabbitMQ, not standard amqp
                            extraArguments['x-expires'] = consumeOptions.queueExpiresMs;
                        }
                        if (consumeOptions.messageExpiresMs) {
                            // x-message-ttl is only feature of RabbitMQ, not standard amqp
                            extraArguments['x-message-ttl'] = consumeOptions.messageExpiresMs;
                        }
                        if (consumeOptions.singleActiveConsumer) {
                            // x-single-active-consumer is only feature of RabbitMQ, not standard amqp
                            extraArguments['x-single-active-consumer'] = consumeOptions.singleActiveConsumer;
                        }
                        if (consumeOptions.queueType === 'quorum') {
                            // default is classic
                            extraArguments['x-queue-type'] = 'quorum';
                            extraArguments['x-quorum-initial-group-size'] = exports.DEFAULT_QUORUM_INITIAL_GROUP_SIZE;
                        }
                        if (consumeOptions.overflow) {
                            // x-overflow is only feature of RabbitMQ, not standard amqp
                            extraArguments['x-overflow'] = consumeOptions.overflow;
                        }
                        return [4 /*yield*/, amqplibChannel.assertQueue(queueName, {
                                deadLetterExchange: typeof consumeOptions.deadLetterExchange !== 'undefined' ? consumeOptions.deadLetterExchange : '',
                                deadLetterRoutingKey: typeof consumeOptions.deadLetterRoutingKey !== 'undefined'
                                    ? consumeOptions.deadLetterRoutingKey
                                    : exports.REJECTED_QUEUE_PREFIX + queueName,
                                maxPriority: queueOptions.maxPriority,
                                autoDelete: typeof consumeOptions.autoDelete !== 'undefined' ? consumeOptions.autoDelete : false,
                                exclusive: typeof consumeOptions.exclusive !== 'undefined' ? consumeOptions.exclusive : false,
                                durable: typeof consumeOptions.durable !== 'undefined' ? consumeOptions.durable : true,
                                arguments: extraArguments,
                                maxLength: typeof consumeOptions.maxLength !== 'undefined' ? consumeOptions.maxLength : undefined,
                            })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    ChannelProvider.prototype.bindQueue = function (amqplibChannel, queueName, exchangeName, routingKey, routingHeaders) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(exchangeName !== '')) return [3 /*break*/, 2];
                        return [4 /*yield*/, amqplibChannel.bindQueue(queueName, exchangeName, routingKey, routingHeaders)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    ChannelProvider.prototype.unbindQueue = function (amqplibChannel, queueName, exchangeName, routingKey, routingHeaders) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(exchangeName !== '')) return [3 /*break*/, 2];
                        return [4 /*yield*/, amqplibChannel.unbindQueue(queueName, exchangeName, routingKey, routingHeaders)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        (0, lockedDecorator_1.locked)("AMQP.ChannelProvider.getAmqplibConnection", { scope: 'instance', maxPending: MAX_PENDING_TASKS }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], ChannelProvider.prototype, "getAmqplibConnection", null);
    __decorate([
        (0, lockedDecorator_1.locked)(function (identifier) { return "AMQP.ChannelProvider.getOrCreateAmqplibChannel.".concat(identifier); }, {
            scope: 'instance',
            maxPending: MAX_PENDING_TASKS,
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, Function]),
        __metadata("design:returntype", Promise)
    ], ChannelProvider.prototype, "getOrCreateAmqplibChannel", null);
    return ChannelProvider;
}());
exports.default = ChannelProvider;
//# sourceMappingURL=ChannelProvider.js.map