"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidNumericOperator = void 0;
exports.default = isNumericOperatorValid;
const Validation_1 = require("./Validation");
function isNumericOperatorValid(operator) {
    const validation = (0, Validation_1.createValidation)(operator);
    const isValidTypeOperator = typeof operator === 'string';
    if (isValidTypeOperator) {
        switch (operator) {
            case '<':
                break;
            case '>':
                break;
            case '<=':
                break;
            case '>=':
                break;
            case '=':
                break;
            case '!=':
                break;
            default:
                validation.addError(new InvalidNumericOperator(operator));
        }
    }
    else {
        validation.addError(new InvalidNumericOperator(operator));
    }
    return validation.getOutput();
}
class InvalidNumericOperator extends Error {
    constructor(operator) {
        super(`Numeric operator is not valid: ${operator}`);
    }
}
exports.InvalidNumericOperator = InvalidNumericOperator;
