"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidForEnvironment = exports.NodeEnvironments = void 0;
const lodash_1 = require("lodash");
/**
 * We use explicitly only 3 NODE_ENVs
 * On other environments like experimental, staging or demo is used production environment
 */
var NodeEnvironments;
(function (NodeEnvironments) {
    /** @deprecated use Development instead */
    NodeEnvironments["Dev"] = "dev";
    NodeEnvironments["Development"] = "development";
    NodeEnvironments["Test"] = "test";
    NodeEnvironments["Production"] = "production";
})(NodeEnvironments || (exports.NodeEnvironments = NodeEnvironments = {}));
/**
 * @nodeEnv should be ideally process.env.NODE_ENV
 *
 * This validation method is mainly intended for validation of the env for zod
 *
 * Example usage:
 * ```
 * auth0_test_domain: z
 * 	.string()
 * 	.optional()
 * 	.refine(
 * 		(value) =>
 * 			isValidForEnvironment({
 * 				nodeEnv: process.env.NODE_ENV,
 * 				expectedEnvironment: NodeEnvironments.Test,
 * 				value,
 * 			}),
 * 		{
 * 			message: `Variable auth0_test_domain is required for ${NodeEnvironments.Test} environment.`,
 * 		},
 * 	)
 * ```
 */
const isValidForEnvironment = ({ nodeEnv, expectedEnvironment, value, }) => nodeEnv !== expectedEnvironment || !(0, lodash_1.isUndefined)(value);
exports.isValidForEnvironment = isValidForEnvironment;
