"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidVolume = exports.validKeys = void 0;
exports.default = validateVolumeSettings;
exports.isValidVolumeValue = isValidVolumeValue;
const isValidUnsignedInteger_1 = require("../../../Validation/isValidUnsignedInteger");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    volume: true,
};
function validateVolumeSettings(settings) {
    var _a;
    const { volume } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notVolumeValid = !isValidVolumeValue(volume);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notVolumeValid) {
        validation.addError(new InvalidVolume(volume));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function isValidVolumeValue(volume) {
    const isVolumeUnsignedInteger = (0, isValidUnsignedInteger_1.default)(volume);
    const isVolumeInLimit = typeof volume === 'number' && volume <= 100;
    if (isVolumeUnsignedInteger && isVolumeInLimit) {
        return true;
    }
    else {
        return false;
    }
}
class InvalidVolume extends Error {
    constructor(volume) {
        super(`Volume has to be between 0 and 100 inclusive: ${volume}`);
    }
}
exports.InvalidVolume = InvalidVolume;
