"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidFrameRate = exports.InvalidResolutionWidth = exports.InvalidResolutionHeight = exports.validKeys = void 0;
exports.default = validateResolutionSettings;
const isValidUnsignedInteger_1 = require("../../../Validation/isValidUnsignedInteger");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    height: true,
    width: true,
    framerate: true,
};
function validateResolutionSettings(settings) {
    var _a;
    const { height, width, framerate } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notHeightValid = !(0, isValidUnsignedInteger_1.default)(height);
    const notWidthValid = !(0, isValidUnsignedInteger_1.default)(width);
    const notFrameRateValid = framerate !== undefined && !(0, isValidUnsignedInteger_1.default)(framerate);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notHeightValid) {
        validation.addError(new InvalidResolutionHeight(height));
    }
    if (notWidthValid) {
        validation.addError(new InvalidResolutionWidth(width));
    }
    if (notFrameRateValid) {
        validation.addError(new InvalidFrameRate(framerate));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidResolutionHeight extends Error {
    constructor(height) {
        super(`Resolution Settings Height is not positive integer ${height}`);
    }
}
exports.InvalidResolutionHeight = InvalidResolutionHeight;
class InvalidResolutionWidth extends Error {
    constructor(width) {
        super(`Resolution Settings Width is not positive integer ${width}`);
    }
}
exports.InvalidResolutionWidth = InvalidResolutionWidth;
class InvalidFrameRate extends Error {
    constructor(framerate) {
        super(`Frame rate is not positive integer ${framerate}`);
    }
}
exports.InvalidFrameRate = InvalidFrameRate;
