import { z } from 'zod';
export declare const ResolutionItemSchema: z.ZodObject<{
    width: z.ZodNumber;
    height: z.ZodNumber;
    framerate: z.ZodOptional<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    height: number;
    width: number;
    framerate?: number | undefined;
}, {
    height: number;
    width: number;
    framerate?: number | undefined;
}>;
export type ResolutionItem = z.infer<typeof ResolutionItemSchema>;
declare type ResolutionList = ResolutionItem[];
export default ResolutionList;
