"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidSupportedResolutions = exports.InvalidExtendedManagement = exports.InvalidProvisionedSince = exports.InvalidName = exports.InvalidModel = exports.InvalidTags = exports.InvalidFirmwareType = exports.InvalidFirmwareVersion = exports.InvalidApplicationType = void 0;
exports.default = isAlertFilterValid;
const Validation_1 = require("../../Validation/Validation");
const isValidApplicationType_1 = require("../../Application/Validation/isValidApplicationType");
const validateSemverWithVersion_1 = require("./validateSemverWithVersion");
const validateResolutionSettings_1 = require("../../Device/Settings/Validation/validateResolutionSettings");
const validateSemverWithVersion_2 = require("./validateSemverWithVersion");
function isAlertFilterValid(alertFilter) {
    var _a;
    const filter = (_a = alertFilter) !== null && _a !== void 0 ? _a : {};
    const validation = (0, Validation_1.createValidation)({});
    if (filter.applicationType) {
        const validAlertType = (0, isValidApplicationType_1.default)(filter.applicationType);
        if (!validAlertType) {
            validation.addError(new InvalidApplicationType(filter.applicationType));
        }
    }
    if (filter.applicationVersion) {
        const validAppVersion = (0, validateSemverWithVersion_1.default)(filter.applicationVersion);
        if (validAppVersion.hasErrors()) {
            validation.addError(new validateSemverWithVersion_2.InvalidApplicationVersion(filter.applicationVersion));
        }
    }
    if (filter.frontDisplayVersion) {
        const frontDisplayVersionValid = (0, validateSemverWithVersion_1.default)(filter.frontDisplayVersion);
        if (frontDisplayVersionValid.hasErrors()) {
            validation.addError(new validateSemverWithVersion_2.InvalidApplicationVersion(filter.frontDisplayVersion));
        }
    }
    if (filter.firmwareType) {
        const isValidFirmwareType = typeof filter.firmwareType === 'string';
        if (!isValidFirmwareType) {
            validation.addError(new InvalidFirmwareType(filter.firmwareType));
        }
    }
    if (filter.firmwareVersion) {
        const isValidFirmwareVersion = typeof filter.firmwareVersion === 'string';
        if (!isValidFirmwareVersion) {
            validation.addError(new InvalidFirmwareVersion(filter.firmwareVersion));
        }
    }
    if (filter.managementPackageVersion) {
        const isValidManagementPackages = (0, validateSemverWithVersion_1.default)(filter.managementPackageVersion);
        if (isValidManagementPackages.hasErrors()) {
            validation.addError(new validateSemverWithVersion_2.InvalidApplicationVersion(filter.managementPackageVersion));
        }
    }
    if (filter.tagUids) {
        const isValidTags = Array.isArray(filter.tagUids);
        const isTagValid = isValidTags && filter.tagUids.every((tag) => typeof tag === 'string');
        if (!isTagValid) {
            validation.addError(new InvalidTags(filter.tagUids));
        }
    }
    if (filter.model) {
        const isValidModel = typeof filter.model === 'string' && filter.model.length > 1;
        if (!isValidModel) {
            validation.addError(new InvalidModel(filter.model));
        }
    }
    if (filter.name) {
        const isValidName = typeof filter.name === 'string' && filter.name.length > 1;
        if (!isValidName) {
            validation.addError(new InvalidName(filter.name));
        }
    }
    if (filter.extendedManagement) {
        const isValidExtendedManagement = typeof filter.extendedManagement === 'boolean';
        if (isValidExtendedManagement) {
            validation.addError(new InvalidExtendedManagement(filter.extendedManagement));
        }
    }
    if (filter.provisionedSince) {
        const isValidObject = filter.provisionedSince instanceof Date;
        if (!isValidObject) {
            validation.addError(new InvalidProvisionedSince(filter.provisionedSince));
        }
    }
    if (filter.supportedResolutions) {
        const isValidSupportedResolution = (0, validateResolutionSettings_1.default)(filter.supportedResolutions);
        if (isValidSupportedResolution.hasErrors()) {
            validation.addError(new InvalidSupportedResolutions(filter.supportedResolutions));
        }
    }
    return validation.getOutput();
}
class InvalidApplicationType extends Error {
    constructor(type) {
        super(`Application Type is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidApplicationType = InvalidApplicationType;
class InvalidFirmwareVersion extends Error {
    constructor(type) {
        super(`Firmware version is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidFirmwareVersion = InvalidFirmwareVersion;
class InvalidFirmwareType extends Error {
    constructor(type) {
        super(`FirmwareType is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidFirmwareType = InvalidFirmwareType;
class InvalidTags extends Error {
    constructor(type) {
        super(`Tags items are not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidTags = InvalidTags;
class InvalidModel extends Error {
    constructor(type) {
        super(`Model is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidModel = InvalidModel;
class InvalidName extends Error {
    constructor(type) {
        super(`Name is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidName = InvalidName;
class InvalidProvisionedSince extends Error {
    constructor(type) {
        super(`Provisioned since is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidProvisionedSince = InvalidProvisionedSince;
class InvalidExtendedManagement extends Error {
    constructor(type) {
        super(`Extended management is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidExtendedManagement = InvalidExtendedManagement;
class InvalidSupportedResolutions extends Error {
    constructor(type) {
        super(`Supported resolutions is not valide ${JSON.stringify(type)}`);
    }
}
exports.InvalidSupportedResolutions = InvalidSupportedResolutions;
