/**
 * All possible options of notification which can be used to notify user about alerts.
 * All can be enabled or disabled.
 * If no option is specified, the default option is `ActivatedSummary`.
 */
export type NotificationOptions = {
    /**
     * Option which used to notify user about aggregated summary of alerts.
     * It is a default option if no other option is specified.
     * @default {true}
     */
    activatedSummary?: boolean;
    /**
     * Option which used to notify user about alerts per device.
     * Similar to activated summary but per device.
     * @default {false}
     */
    activatedPerDevice?: boolean;
    /**
     * Option which used to notify user about resolved summary of alerts.
     * Happens when the system determines that the alert is not applied on device anymore.
     * @default {false}
     */
    resolvedSummary?: boolean;
    /**
     * Option which used to notify user about resolved alerts per device.
     * Similar to resolved summary but per device.
     * @default {false}
     */
    resolvedPerDevice?: boolean;
};
