import { ResolutionItem } from '../Device/Resolution/ResolutionList';
import ApplicationType from '../Application/ApplicationType';
import { SemverOperator } from './AlertCondition';
/**
 * Filter devices of organization.
 */
export interface AlertFilter {
    /** Basic grouping of devices by system */
    applicationType?: ApplicationType;
    /** Semver comparison of core app version */
    applicationVersion?: [SemverOperator, string];
    /** Semver comparison of internal front-display library version */
    frontDisplayVersion?: [SemverOperator, string];
    /** Partial matching of string (e.g. rpi4 or just rpi) */
    firmwareType?: string;
    /** Partial matching of string */
    firmwareVersion?: string;
    /** Semver comparison of core management package version */
    managementPackageVersion?: [SemverOperator, string];
    /** Semver comparison of core front package version */
    frontPackageVersion?: [SemverOperator, string];
    /** List of tags. Device has match all tags in list */
    tagUids?: string[];
    /** Partial matching of string */
    model?: string;
    /** Partial matching of string */
    name?: string;
    /** Filter device with or without extended management (e.g. Magic Info) */
    extendedManagement?: boolean;
    /** Filter only devices provisioned since the date */
    provisionedSince?: Date;
    /** Filter only devices supporting specified resolution */
    supportedResolutions?: ResolutionItem;
    /** Filter devices in the given locations */
    locationUids?: string[];
    /**
     * Filter devices with the given location tags
     * @note It `locationUids` and `locationTagsUids` are both specified
     * It will filter devices that are in the intersection of the two sets
     */
    locationTagsUids?: string[];
}
