import { z } from 'zod';
/**
 * The new version of the UID generated using NanoID package.
 */
export declare const UIDSchema: z.ZodString;
/**
 * The old version of UID generated in our system. It has hexadecimal characters and 50 characters length.
 * It used to be generated using generateUniqueHash() function of the @signageos/lib package.
 * Use the generators.ts -> uid() function to generate new UIDs.
 */
export declare const LegacyUIDSchema: z.ZodString;
export declare const HexColorSchema: z.ZodEffects<z.ZodString, string, string>;
export declare const DomainSchema: z.ZodEffects<z.ZodString, string, string>;
/**
 * The old numeric id value generated in our system.
 * Primarily was used because of postgresql database (i.e. accountId in account table).
 */
export declare const NumericIdSchema: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
export declare const TimeSchema: z.ZodString;
export declare const UsernameSchema: z.ZodString;
export declare const NameSchema: z.ZodEffects<z.ZodString, string, string>;
export declare const MacAddressSchema: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
